/*
sm.h

Created:	May 28, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#ifndef SM_H
#define SM_H

typedef struct sm_action
{
	void (*sma_tlu) ARGS(( void ));
	void (*sma_tld) ARGS(( void ));
	void (*sma_tls) ARGS(( void ));
	void (*sma_tlf) ARGS(( void ));
	void (*sma_irc) ARGS(( int retry_cnt ));
	void (*sma_zrc) ARGS(( void ));
	void (*sma_scr) ARGS(( void ));
	void (*sma_sca) ARGS(( void ));
	void (*sma_scn) ARGS(( void ));
	void (*sma_str) ARGS(( void ));
	void (*sma_sta) ARGS(( void ));
	void (*sma_scj) ARGS(( void ));
	void (*sma_ser) ARGS(( void ));
} sm_action_ut;

typedef struct sm_state
{
	void (*sms_func) ARGS(( struct sm_state *sm_state, int event ));
	char *sms_name;
	sm_action_ut sms_action;
	int sms_isup;
	int sms_max_configure;
	int sms_max_terminate;
	int sms_restart_counter;
	int sms_restart_timer;
	struct clck_timer sms_timer;

	int sms_options_inited;
	struct pkt *sms_scr_pkt;
	struct pkt *sms_sca_pkt;
	struct pkt *sms_scn_pkt;
	struct pkt **sms_ack_pkt_p;
	struct pkt **sms_nak_pkt_p;
	struct pkt **sms_rej_pkt_p;

	int sms_scn_type;
	int sms_type_req;
	int sms_type_ack;
	int sms_type_nak;
	int sms_type_reject;
	u8_t sms_last_snd_seq;
	u8_t sms_last_rcvd_seq;
	void (*sms_option_init) ARGS(( void ));
	struct pkt *(*sms_mk_request) ARGS(( void ));
	void (*sms_send_data) ARGS(( int type, void *data, size_t size ));
	int (*sms_got_request) ARGS(( size_t length, u8_t *data, 
		struct pkt **ack_p, struct pkt **nak_p, struct pkt **rej_p ));
	void (*sms_sending_ack) ARGS(( void ));
	void (*sms_got_ack) ARGS(( void ));
	int (*sms_got_nak) ARGS(( size_t length, u8_t *data,
		struct pkt *req_pkt ));
	int (*sms_got_reject) ARGS(( size_t length, u8_t *data,
		struct pkt *req_pkt ));
} sm_state_ut;

#define SM_DFLT_MAX_CONFIGURE	10
#define SM_DFLT_MAX_TERMINATE	2
#define SM_DFLT_RESTART_TIMER	(3*CLOCKS_PER_SEC)

void sm_init ARGS(( sm_state_ut *sm_state, char *name , sm_action_ut *action ));
void sm_up ARGS(( sm_state_ut *sm_state ));
void sm_down ARGS(( sm_state_ut *sm_state ));
void sm_open ARGS(( sm_state_ut *sm_state ));
void sm_close ARGS(( sm_state_ut *sm_state ));
void sm_rcr_plus ARGS(( sm_state_ut *sm_state ));
void sm_rcr_minus ARGS(( sm_state_ut *sm_state ));
void sm_rca ARGS(( sm_state_ut *sm_state ));
void sm_rcn ARGS(( sm_state_ut *sm_state ));
void sm_rtr ARGS(( sm_state_ut *sm_state ));
void sm_rta ARGS(( sm_state_ut *sm_state ));
void sm_ruc ARGS(( sm_state_ut *sm_state ));
void sm_rxj_minus ARGS(( sm_state_ut *sm_state ));
void sm_rxj_plus ARGS(( sm_state_ut *sm_state ));

#endif /* SM_H */

/*
 * $PchHeader: /mount/hd2/minix/local/cmd/ppp/RCS/sm.h,v 1.1 1995/02/14 07:52:41 philip Exp $
 */
