/*
optlib.h

Created:	Dec 3, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#ifndef OPTLIB_H
#define OPTLIB_H

struct option_ent;
struct opt_on_off;
struct pkt;
struct sm_state;

void ol_send_cr ARGS(( struct sm_state *state_p ));
void ol_init ARGS(( struct option_ent *table ));
struct pkt *ol_mk_request ARGS(( struct option_ent *table ));
void ol_configure_req ARGS(( struct sm_state *state_p, int identifier,
	size_t length, u8_t *data, struct pkt *pkt ));
void ol_configure_ack ARGS(( struct sm_state *state_p, int identifier,
	size_t length, u8_t *data, struct pkt *pkt ));
void ol_configure_nak ARGS(( struct sm_state *state_p, int identifier,
	size_t length, u8_t *data, struct pkt *pkt ));
void ol_configure_reject ARGS(( struct sm_state *state_p, int identifier,
	size_t length, u8_t *data, struct pkt *pkt ));
void ol_ack_option ARGS(( struct sm_state *state_p, void *data, size_t size ));
void ol_nak_option ARGS(( struct sm_state *state_p, void *data, size_t size ));
void ol_reject_option ARGS(( struct sm_state *state_p, void *data,
	size_t size ));
int ol_got_request ARGS(( struct sm_state *state_p, struct option_ent *table,
	size_t length, u8_t *data, struct pkt **ack_p, struct pkt **nak_p,
	struct pkt **rej_p ));
void ol_sca ARGS(( struct sm_state *state_p ));
void ol_scn ARGS(( struct sm_state *state_p ));
void ol_sending_ack ARGS(( struct option_ent *table ));
void ol_got_ack ARGS(( struct option_ent *table ));
int ol_got_nak ARGS(( struct option_ent *table, size_t length, u8_t *data,
	struct pkt *req_pkt ));
int ol_got_reject ARGS(( struct option_ent *table, size_t length, u8_t *data,
	struct pkt *req_pkt ));
int ol_on_off_option ARGS(( struct sm_state *state_p, char *name, int type,
	struct opt_on_off *snd_p, struct opt_on_off *rcv_p, int action,
	void *data ));

typedef int (*option_func_ut) ARGS(( int action, void *data ));
typedef struct option_ent
{
	int oe_code;
	option_func_ut oe_func;
} option_ent_ut;

#define OEC_INIT	0
#define OEC_SND_REQ	1
#define OEC_RCV_REQ	2
#define OEC_RCV_OPTION	3
#define OEC_RCV_REQ_END	4
#define OEC_GOT_NAK	5
#define OEC_GOT_REJ	6
#define OEC_SENT_ACK	7
#define OEC_GOT_ACK	8

typedef struct opt_on_off
{
	int action;

	int curr_action;
	u8_t *curr_opt;
	int rej_retry;
	int nak_retry;
} opt_on_off_ut;

#endif /* OPTLIB_H */

/*
 * $PchHeader: /mount/hd2/minix/local/cmd/ppp/RCS/optlib.h,v 1.1 1995/02/14 07:52:41 philip Exp $
 */
