/*
lcp_option.c

Created:	Dec 3, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#include <assert.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>

#include "ansi.h"
#include "debug.h"
#include "lcp.h"
#include "optlib.h"
#include "pkt.h"
#include "ppp.h"

#define CHUNK_SIZE	64

static int lcpo_pfc ARGS(( int action, void *data ));
static int lcpo_acfc ARGS(( int action, void *data ));

static option_ent_ut option_table[]=
{
	LCP_OPTION_PFC, lcpo_pfc,
	LCP_OPTION_ACFC, lcpo_acfc,
	0, 0,
};

DEFUN
(void lcpo_parse_arg, (action, option),
	int action AND
	char *option
)
{
	opt_on_off_ut *opt_pfc_snd_p, *opt_pfc_rcv_p;
	opt_on_off_ut *opt_acfc_snd_p, *opt_acfc_rcv_p;
	char *oe;
	int ol;

	DPRINTF(0, ("lcpo_parse_arg(%d, '%s')\n", action, option));
	if (strncmp(option, OPT_PFC, strlen(OPT_PFC)) == 0)
	{
		opt_pfc_snd_p= NULL;
		opt_pfc_rcv_p= NULL;

		if ((oe= strchr(option, '=')) != NULL)
			ol= oe-option;
		else
			ol= strlen(option);

		if (ol == strlen(OPT_PFC))
		{
			opt_pfc_snd_p= &opt_pfc_snd;
			opt_pfc_rcv_p= &opt_pfc_rcv;
		}
		else if (ol == strlen(OPT_PFC_SND) &&
			strncmp(option, OPT_PFC_SND,
			strlen(OPT_PFC_SND)) == 0)
		{
			opt_pfc_snd_p= &opt_pfc_snd;
		}
		else if (ol == strlen(OPT_PFC_RCV) &&
			strncmp(option, OPT_PFC_RCV,
			strlen(OPT_PFC_RCV)) == 0)
		{
			opt_pfc_rcv_p= &opt_pfc_rcv;
		}
		else
		{
			DPRINTF(0,
			("lcpo_parse_arg: unrecognized option '%.*s'\n",
				ol, option));
			exit(1);
		}
		if (action != PPP_OPT_NOCHANGE)
		{
			if (opt_pfc_snd_p)
				opt_pfc_snd_p->action= action;
			if (opt_pfc_rcv_p)
				opt_pfc_rcv_p->action= action;
		}
		if (option[ol] == '=')
		{
			DPRINTF(0, ("lcpo_parse_arg(pcf): no value epected\n"));
			exit(1);
		}
		assert(option[ol] == '\0');
		if (opt_pfc_snd_p)
		{
			DPRINTF(1, ("lcpo_parse_arg: opt_pfc_snd= { %d }\n",
				opt_pfc_snd_p->action));
		}
		if (opt_pfc_rcv_p)
		{
			DPRINTF(1, ("lcpo_parse_arg: opt_pfc_rcv= { %d }\n",
				opt_pfc_rcv_p->action));
		}
	}
	else if (strncmp(option, OPT_ACFC, strlen(OPT_ACFC)) == 0)
	{
		opt_acfc_snd_p= NULL;
		opt_acfc_rcv_p= NULL;

		if ((oe= strchr(option, '=')) != NULL)
			ol= oe-option;
		else
			ol= strlen(option);

		if (ol == strlen(OPT_ACFC))
		{
			opt_acfc_snd_p= &opt_acfc_snd;
			opt_acfc_rcv_p= &opt_acfc_rcv;
		}
		else if (ol == strlen(OPT_ACFC_SND) &&
			strncmp(option, OPT_ACFC_SND,
			strlen(OPT_ACFC_SND)) == 0)
		{
			opt_acfc_snd_p= &opt_acfc_snd;
		}
		else if (ol == strlen(OPT_ACFC_RCV) &&
			strncmp(option, OPT_ACFC_RCV,
			strlen(OPT_ACFC_RCV)) == 0)
		{
			opt_acfc_rcv_p= &opt_acfc_rcv;
		}
		else
		{
			DPRINTF(0,
			("lcpo_parse_arg: unrecognized option '%.*s'\n",
				ol, option));
			exit(1);
		}
		if (action != PPP_OPT_NOCHANGE)
		{
			if (opt_acfc_snd_p)
				opt_acfc_snd_p->action= action;
			if (opt_acfc_rcv_p)
				opt_acfc_rcv_p->action= action;
		}
		if (option[ol] == '=')
		{
			DPRINTF(0,
				("lcpo_parse_arg(acfc): no value epected\n"));
			exit(1);
		}
		assert(option[ol] == '\0');
		if (opt_acfc_snd_p)
		{
			DPRINTF(1, ("lcpo_parse_arg: opt_acfc_snd= { %d }\n",
				opt_acfc_snd_p->action));
		}
		if (opt_acfc_rcv_p)
		{
			DPRINTF(1, ("lcpo_parse_arg: opt_acfc_rcv= { %d }\n",
				opt_acfc_rcv_p->action));
		}
	}
	else
	{
		DPRINTF(0, ("lcpo_parse_arg: unrecognized option '%s'\n",
			option));
		exit(1);
	}
}


DEFUN_VOID (void lcpo_init)
{
	ol_init(option_table);
}


DEFUN_VOID (pkt_ut *lcpo_mk_request)
{
	return ol_mk_request(option_table);
}


DEFUN
(int lcpo_got_request, (length, data, ack_p, nak_p, rej_p),
size_t length AND
u8_t *data AND
pkt_ut **ack_p AND
pkt_ut **nak_p AND
pkt_ut **rej_p
)
{
	return ol_got_request(&lcp_state, option_table, length, data,
		ack_p, nak_p, rej_p);
}


DEFUN_VOID (void lcpo_sending_ack)
{
	ol_sending_ack(option_table);
}


DEFUN_VOID (void lcpo_got_ack)
{
	ol_got_ack(option_table);
}


DEFUN
(int lcpo_got_nak, (length, data, req_pkt),
size_t length AND
u8_t *data AND
pkt_ut *req_pkt
)
{
	return ol_got_nak(option_table, length, data, req_pkt);
}


DEFUN
(int lcpo_got_reject, (length, data, req_pkt),
size_t length AND
u8_t *data AND
pkt_ut *req_pkt
)
{
	ol_got_reject(option_table, length, data, req_pkt);
}


DEFUN
(static int lcpo_pfc, (action, data),
	int action AND
	void *data
)
{
	switch(action)
	{
	case OEC_INIT:
		opt_pfc_snd.rej_retry= LCP_DFLT_MAX_REJ;
		opt_pfc_snd.nak_retry= LCP_DFLT_MAX_NAK;
		opt_pfc_rcv.rej_retry= LCP_DFLT_MAX_REJ;
		opt_pfc_rcv.nak_retry= LCP_DFLT_MAX_NAK;

		/* Fall through */
	case OEC_SND_REQ:
	case OEC_RCV_REQ:
	case OEC_RCV_OPTION:
	case OEC_RCV_REQ_END:
	case OEC_GOT_NAK:
	case OEC_GOT_REJ:
		return ol_on_off_option(&lcp_state, "pfc", LCP_OPTION_PFC,
			&opt_pfc_snd, &opt_pfc_rcv, action, data);
	case OEC_SENT_ACK:
		DPRINTF(1, ("lcpo_pfc(sent_ack)\n"));
		action= opt_pfc_rcv.curr_action;
		if (action == PPP_OPT_ON || action == PPP_OPT_FORCED_ON)
		{
			DPRINTF(1,
			("lcpo_pfc: sending compressed protocol fields\n"));
			ppp_snd_hc_proto= 1;
		}
		else
		{
			assert(action == PPP_OPT_OFF ||
				action == PPP_OPT_FORCED_OFF);
			DPRINTF(1,
			("lcpo_pfc: not sending compressed protocol fields\n"));
			ppp_snd_hc_proto= 0;
		}
		return 0;
	case OEC_GOT_ACK:
		DPRINTF(1, ("lcpo_pfc(got_ack)\n"));
		action= opt_pfc_snd.curr_action;
		if (action == PPP_OPT_ON || action == PPP_OPT_FORCED_ON)
		{
			DPRINTF(1,
			("lcpo_pfc: receiving compressed protocol fields\n"));
			ppp_rcv_hc_proto= 1;
		}
		else
		{
			assert(action == PPP_OPT_OFF ||
				action == PPP_OPT_FORCED_OFF);
			DPRINTF(1,
		("lcpo_pfc: not receiving compressed protocol fields\n"));
			ppp_rcv_hc_proto= 0;
		}
		return 0;
	default:
		DPRINTF(0, ("lcpo_pfc: unknown action %d\n", action));
		abort();
	}
}


DEFUN
(static int lcpo_acfc, (action, data),
	int action AND
	void *data
)
{
	DPRINTF(1, ("lcpo_acfc: %d, %d\n",
		opt_acfc_snd.curr_action, opt_acfc_rcv.curr_action));

	switch(action)
	{
	case OEC_INIT:
		opt_acfc_snd.rej_retry= LCP_DFLT_MAX_REJ;
		opt_acfc_snd.nak_retry= LCP_DFLT_MAX_NAK;
		opt_acfc_rcv.rej_retry= LCP_DFLT_MAX_REJ;
		opt_acfc_rcv.nak_retry= LCP_DFLT_MAX_NAK;

		/* Fall through */
	case OEC_SND_REQ:
	case OEC_RCV_REQ:
	case OEC_RCV_OPTION:
	case OEC_RCV_REQ_END:
	case OEC_GOT_NAK:
	case OEC_GOT_REJ:
		return ol_on_off_option(&lcp_state, "acfc", LCP_OPTION_ACFC,
			&opt_acfc_snd, &opt_acfc_rcv, action, data);
	case OEC_SENT_ACK:
		DPRINTF(1, ("lcpo_acfc(sent_ack)\n"));
		action= opt_acfc_rcv.curr_action;
		if (action == PPP_OPT_ON || action == PPP_OPT_FORCED_ON)
		{
			DPRINTF(1,
		("lcpo_acfc: sending compressed address and control fields\n"));
			ppp_snd_hc_address= 1;
		}
		else
		{
			assert(action == PPP_OPT_OFF ||
				action == PPP_OPT_FORCED_OFF);
			DPRINTF(1,
	("lcpo_acfc: not sending compressed address and control fields\n"));
			ppp_snd_hc_address= 0;
		}
		return 0;
	case OEC_GOT_ACK:
		DPRINTF(1, ("lcpo_acfc(got_ack)\n"));
		action= opt_acfc_snd.curr_action;
		if (action == PPP_OPT_ON || action == PPP_OPT_FORCED_ON)
		{
			DPRINTF(1,
	("lcpo_acfc: receiving compressed address and control fields\n"));
			ppp_rcv_hc_address= 1;
		}
		else
		{
			assert(action == PPP_OPT_OFF ||
				action == PPP_OPT_FORCED_OFF);
			DPRINTF(1,
	("lcpo_acfc: not receiving compressed address and control fields\n"));
			ppp_rcv_hc_address= 0;
		}
		return 0;
	default:
		DPRINTF(0, ("lcpo_acfc: unknown action %d\n", action));
		abort();
	}
}

/*
 * $PchHeader: /mount/hd2/minix/local/cmd/ppp/RCS/lcp_option.c,v 1.1 1995/02/14 07:52:41 philip Exp $
 */
