/*
lcp.h

Created:	May 24, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#ifndef LCP_H
#define LCP_H

void lcp_init ARGS(( void ));

struct pkt;

/* lcp.c */
void lcp_arrived ARGS(( struct pkt *pkt ));
void lcp_reject_proto ARGS(( struct pkt *pkt, u16_t protocol ));

/* lcp_option.c */
void lcpo_parse_arg ARGS(( int action, char *option ));
void lcpo_init ARGS(( void ));
struct pkt *lcpo_mk_request ARGS(( void ));
int lcpo_got_request ARGS(( size_t length, u8_t *data, 
	struct pkt **ack_p, struct pkt **nak_p, struct pkt **rej_p ));
void lcpo_sending_ack ARGS(( void ));
void lcpo_got_ack ARGS(( void ));
int lcpo_got_nak ARGS(( size_t length, u8_t *data, struct pkt *req_pkt ));
int lcpo_got_reject ARGS(( size_t length, u8_t *data, struct pkt *req_pkt ));

extern struct sm_state lcp_state;

#define LCP_DFLT_MAX_CONFIGURE	10
#define LCP_DFLT_MAX_TERMINATE	2
#define LCP_DFLT_RESTART_TIMER	(3*CLOCKS_PER_SEC)
#define LCP_DFLT_MAX_REJ	3		/* accept 3 rejects before
						 * deciding that there is an
						 * on/off conflict
						 */
#define LCP_DFLT_MAX_NAK	10		/* accept 10 naks before
						 * deciding that there is an
						 * value conflict
						 */


#define LCP_TYPE_CONFIGURE_REQ		1
#define LCP_TYPE_CONFIGURE_ACK		2
#define LCP_TYPE_CONFIGURE_NAK		3
#define LCP_TYPE_CONFIGURE_REJECT	4
#define LCP_TYPE_TERMINATE_REQ		5
#define LCP_TYPE_TERMINATE_ACK		6
#define LCP_TYPE_CODE_REJECT		7
#define LCP_TYPE_PROTOCOL_REJECT	8

#define LCP_OPTION_PFC			7
#define LCP_OPTION_ACFC			8

#define OPT_PFC				"lcp.pfc"
#define OPT_PFC_SND			"lcp.pfc.snd"
#define OPT_PFC_RCV			"lcp.pfc.rcv"
#define OPT_ACFC			"lcp.acfc"
#define OPT_ACFC_SND			"lcp.acfc.snd"
#define OPT_ACFC_RCV			"lcp.acfc.rcv"

extern struct opt_on_off opt_pfc_snd;
extern struct opt_on_off opt_pfc_rcv;
extern struct opt_on_off opt_acfc_snd;
extern struct opt_on_off opt_acfc_rcv;

#endif /* LCP_H */

/*
 * $PchHeader: /mount/hd2/minix/local/cmd/ppp/RCS/lcp.h,v 1.1 1995/02/14 07:52:41 philip Exp $
 */
