/*
fcs.c

Created:	May 25, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#include <sys/types.h>
#include <assert.h>

#include "ansi.h"
#include "fcs.h"

static u16_t fcstab[256];

DEFUN_VOID (void fcs_init)
{
	unsigned int b, v;
	int i;

	assert(sizeof(u16_t) == 2);
	assert((u16_t)-1 > 0);

	for (b= 0; b<256; b++)
	{
		v= b;
		for (i= 8; i--; )
			v= v & 1 ? (v >> 1) ^ FCS_P : v >> 1;

		fcstab[b]= v;
	}

#if 0
	for (b= 0; b<256; b++)
		printf("0x%04x%c", fcstab[b], ((b & 7) != 7) ? ' ' : '\n');
#endif
}

DEFUN
(u16_t pppfcs, (fcs, data, size),
	u16_t fcs AND
	u8_t *data AND
	size_t size
)
{
	while (size--)
		fcs= (fcs >> 8) ^ fcstab[(fcs ^ *data++) & 0xFF];

	return fcs;
}

/*
 * $PchHeader: /mount/hd2/minix/local/cmd/ppp/RCS/fcs.c,v 1.1 1995/02/14 07:52:41 philip Exp $
 */
