/*
debug.h

Created:	May 24, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#ifndef DEBUG_H
#define DEBUG_H

#define D_MAX	16

#define DBLOCK(level, code) \
	{ \
		if (level < D_MAX) \
		{ \
			code; \
		} \
	} while(0)

#define DPRINTF(level, args) (((level) < D_MAX) ? \
	 (debug_tmp= (level), dprintf args) : (void)0)
#define DPRINTF_CONT(level, args) (((level) < D_MAX) ? \
	(debug_tmp= (level), dprintf_cont args) : (void)0)

void dprintf ARGS(( char *fmt, ... ));
void dprintf_cont ARGS(( char *fmt, ... ));
void fatal ARGS(( char *fmt, ... ));

extern char *prog_name;
extern int debug_tmp;


#endif /* DEBUG_H */

/*
 * $PchHeader: /mount/hd2/minix/local/cmd/ppp/RCS/debug.h,v 1.2 1995/04/28 07:58:53 philip Exp $
 */
