/*
debug.c

Created:	May 24, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#include <sys/types.h>
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <unistd.h>

#include "ansi.h"
#include "debug.h"

int debug_tmp;
int debug_level= 1;

DEFUN
(void dprintf, (),
	char *fmt AND
	...
)
{
	int level;
	va_list ap;

	level= debug_tmp;

	if (level <= debug_level)
	{
		va_start(ap, fmt);

		fprintf(stderr, "%s[%d]: ", prog_name, getpid());
		vfprintf(stderr, fmt, ap);

		va_end(ap);
	}
}


DEFUN
(void dprintf_cont, (),
	char *fmt AND
	...
)
{
	int level;
	va_list ap;

	level= debug_tmp;

	if (level <= debug_level)
	{
		va_start(ap, fmt);

		vfprintf(stderr, fmt, ap);

		va_end(ap);
	}
}

DEFUN
(void fatal, (),
	char *fmt AND
	...
)
{
	va_list ap;

	va_start(ap, fmt);
	fprintf(stderr, "%s[%d]: fatal error: ", prog_name, getpid());
	vfprintf(stderr, fmt, ap);
	fflush(NULL);
	exit(1);
	/* abort(); */
}

/*
 * $PchHeader: /mount/hd2/minix/local/cmd/ppp/RCS/debug.c,v 1.2 1995/04/28 08:08:41 philip Exp $
 */
