/*
clock.h

Created:	May 24, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#ifndef CLOCK_H
#define CLOCK_H

typedef struct clck_timer
{
	int ct_set;
	clock_t ct_when;
	struct clck_timer *ct_next;
	void (*ct_func) ARGS(( struct clck_timer *timer, void *ref ));
	void *ct_ref;
} clck_timer_ut;

void clck_init ARGS(( void ));
void clck_chk_timers ARGS(( void ));
void clck_init_timer ARGS(( clck_timer_ut *timer, 
			void (*func) ARGS(( clck_timer_ut *timer, void *ref )), 
			void *ref ));
void clck_set_timer ARGS(( struct clck_timer *timer, clock_t when ));
void clck_cancel_timer ARGS(( struct clck_timer *timer ));
clock_t clck_get_time ARGS(( void ));

extern int clck_timer_expired;

#endif /* CLOCK_H */

/*
 * $PchHeader: /mount/hd2/minix/local/cmd/ppp/RCS/clock.h,v 1.1 1995/02/14 07:52:41 philip Exp $
 */
