/* This process is a stub for simple tasks like /sbin/init.  The boot
 * environment variables with the tasks name, say "init", tells which
 * executable to execute, otherwise the default, /sbin/init for example,
 * is used.
 *
 * The name of the task must be supplied as, -DTASK=\"init\".
 */

#define _MINIX_SOURCE
#define _POSIX_SOURCE

#include <sys/types.h>
#include <limits.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>

void errorpr(char *s)
{
	write(2, s, strlen(s));
}

int main(void)
{
  char *why;
  int fd;
  char *task;

  /* Do something like this:
   *	exec ${task-/sbin/task} < /dev/null >/dev/log 2>&1
   */
  (void) open("/dev/null", O_RDONLY);
  (void) open("/dev/log", O_WRONLY);
  dup(1);

  if ((task= getenv(TASK)) == NULL)
  {
  	/* Use the default. */
  	static char sbin_task[256];
  	task= sbin_task;
  	strcpy(task, "/sbin/");
  	strcat(task, TASK);
  }
  execl(task, TASK, (char *) NULL);
  why= strerror(errno);

  errorpr(TASK);
  errorpr(".stub: ");
  errorpr(task);
  errorpr(": ");
  errorpr(why);
  errorpr("\n");

  exit(1);
}

/*
 * $PchId: stub.c,v 1.3 1995/11/28 09:03:56 philip Exp $
 */
