/* A server must occasionally print some message.  It uses the standard library
 * routine prink().  (The name "printf" is really a macro defined as "printk").
 * Printing is done by calling sys_puts, and not by going through FS.
 */

#include <minix/ansi.h>
#include <sys/types.h>
#include <minix/cfg_public.h>
#include <minix/const.h>
#include <minix/type.h>
#include <minix/syslib.h>

#define BUF_SIZE          512	/* print buffer size */

PRIVATE int buf_count;		/* # characters in the buffer */
PRIVATE char print_buf[BUF_SIZE];	/* output is buffered here */

_PROTOTYPE( PUBLIC void putk, (int c)					);
_PROTOTYPE( FORWARD void flush, (void) );

/*===========================================================================*
 *				putk					     *
 *===========================================================================*/
PUBLIC void putk(c)
int c;
{
/* Accumulate another character.  If 0 or buffer full, print it. */

  if (c == 0 || buf_count == BUF_SIZE) flush();
  if (c != 0) print_buf[buf_count++] = c;
}


/*===========================================================================*
 *				flush					     *
 *===========================================================================*/
PRIVATE void flush()
{
/* Flush the print buffer by calling TTY task. */

  if (buf_count == 0) return;
  sys_puts(print_buf, buf_count);
  buf_count = 0;
}

/*
 * $PchId: putk.c,v 1.4 1995/11/28 07:03:16 philip Exp $
 */
