/* This table has one slot per process.  It contains all the memory management
 * information for each process.  Among other things, it defines the text, data
 * and stack segments, uids and gids, and various flags.  The kernel and file
 * systems have tables that are also indexed by process, with the contents
 * of corresponding slots referring to the same process in all three.
 */

EXTERN struct mproc {
  /* Only keep track of address space issues. Ask the kernel for an up to date
   * map.
   */
  phys_bytes mp_virstart;
  phys_bytes mp_virsize;
  char mp_exitstatus;		/* storage for status when process exits */
  char mp_sigstatus;		/* storage for signal # for killed procs */
  pid_t mp_pid;			/* process id */
  pid_t mp_procgrp;		/* pid of process group (used for signals) */
  pid_t mp_wpid;		/* pid this process is waiting for */
  int mp_parent;		/* index of parent process */
  int mp_nice;			/* nice value of the process */

  /* Real and effective uids and gids. */
  uid_t mp_realuid;		/* process' real uid */
  uid_t mp_effuid;		/* process' effective uid */
  gid_t mp_realgid;		/* process' real gid */
  gid_t mp_effgid;		/* process' effective gid */
  uid_t mp_saveuid[2];		/* saved real and effective uid */
  gid_t mp_savegid[2];		/* saved real and effective gid */
  gid_t mp_groups[NGROUPS_MAX];	/* supplementary group id's */
  int mp_ngroups;		/* number of group id's */

  /* Signal handling information. */
  sigset_t mp_ignore;		/* 1 means ignore the signal, 0 means don't */
  sigset_t mp_catch;		/* 1 means catch the signal, 0 means don't */
  sigset_t mp_sigmask;		/* signals to be blocked */
  sigset_t mp_sigmask2;		/* saved copy of mp_sigmask */
  sigset_t mp_sigpending;	/* signals being blocked */
  struct sigaction mp_sigact[_NSIG + 1]; /* as in sigact(2) */
  vir_bytes mp_sigreturn; 	/* address of C library __sigreturn function */

  /* Backwards compatibility for signals. */
  sighandler_t mp_func;		/* all sigs vectored to a single user fcn */

  unsigned mp_flags;		/* flag bits */

  /* For shared text in executables */
  dev_t mp_device;		/* device on which the executable resides */
  ino_t mp_ino;			/* executable's inode */
  time_t mp_ctime;		/* last time the executable was changed */

  /* Pointers for linking process structures */
  struct mproc *mp_next;
  struct mproc *mp_prev;
} mproc[NR_PROCS];

/* Flag values */
#define IN_USE             0x1	/* set when 'mproc' slot in use */
#define WAITING            0x2	/* set by WAIT system call */
#define HANGING            0x4	/* set by EXIT system call */
#define PAUSED             0x8	/* set by PAUSE system call */
#define	TRACED		  0x40	/* set if process is to be traced */
#define STOPPED		  0x80	/* set if process stopped for tracing */
#define SIGSUSPENDED	 0x100	/* set by SIGSUSPEND system call */

#define NIL_MPROC ((struct mproc *) 0)

/*
 * $PchId: mproc.h,v 1.5 1995/11/28 07:22:20 philip Exp $
 */
