/* Constants used by the Memory Manager. */

#define NO_MEM ((phys_clicks) 0)  /* returned by alloc_mem() with mem is up */

#if (CHIP == INTEL && WORD_SIZE == 2)
/*DEBUG*/
/* PAGE_SIZE should be SEGMENT_GRANULARITY and MAX_PAGES MAX_SEGMENTS.
 * The 386 segment granularity is 1 for segments smaller than 1M and 4096
 * above that.  This is not handled properly yet - assume small programs.
 */
#define PAGE_SIZE	  16	/* how many bytes in a page (s.b.HCLICK_SIZE)*/
#define MAX_PAGES       4096	/* how many pages in the virtual addr space */
#endif /* CHIP == INTEL && WORD_SIZE == 2 */

#if (CHIP == INTEL) && VIRT_MEM
#define MEM_PAD_CLICKS		(0x400000 >> CLICK_SHIFT)
				/* allocate memory on 4M boundaries */
#if VMDEXT_MM_NEWEXEC
#define MIN_GAP_SIZE		0x300000 /* at least 3M head+stack space */
#else /* !VMDEXT_MM_NEWEXEC */
#define MIN_GAP_CLICKS		(0x300000 >> CLICK_SHIFT)
				/* at least 3M head+stack space */
#endif  /* VMDEXT_MM_NEWEXEC */
#endif /* CHIP == INTEL && VIRT_MEM */

#define printf        printk

#define INIT_PID	   1	/* init's process id number */

/* For executable caching */
#define EC_ENT_NO	256	/* must be larger than NR_PROCS */
#define EC_HASH_NO	256
#define ec_hash(dev,ino,time) \
	(((dev) ^ ((dev) >> 8) ^ (ino) ^ ((ino) >> 8) ^ (time) ^ \
	((time) >> 8) ^ ((time) >> 16) ^ ((time) >> 24)) & 0xFF)
	/* The result of ec_hash should be suitable for use as an index in
	 * a table of size EC_HASH_NO.
	 */

#if PCH_DEBUG
#define	where()		printf("%s, %d: ", __FILE__, __LINE__)
#else /* !PCH_DEBUG */
#define where()
#endif /* !PCH_DEBUG */

/*
 * $PchId: const.h,v 1.3 1995/11/28 07:19:31 philip Exp $
 */
