/*
mm/compat.c

Implement binary compatibility with older versions of Minix.

Created:	Nov 27, 1992 by Philip Homburg
*/

#include "mm.h"
#include <stdlib.h>
#include "mproc.h"
#include "assert.h"
INIT_ASSERT

#if DEBUG
FORWARD _PROTOTYPE(void print_cpt, (char *name)				);

PRIVATE void print_cpt(name)
char *name;
{
	static print_level= -1;
	char *mmchkcpt;

	if (print_level == 0)
		return;
	else if (print_level == -1)
	{
		mmchkcpt= getenv("mmchkcpt");
		if (mmchkcpt == NULL)
		{
			print_level= 0;
			return;
		}
		print_level= 1;
	}
	printf(
	"(warning) old version of %s(#%d) called by process %d(slot %d)\n",
		name, mm_call, mp->mp_pid, who);
}
#else /* !DEBUG */
#define print_cpt(name)		(void)0
#endif /* DEBUG */


/*===========================================================================*
 *				do_cpt_waitpid				     *
 *===========================================================================*/
int do_cpt_waitpid()
{
  assert(mm_call == V7_EXEC);

  print_cpt("waitpid");

  mm_call= mm_in.m_type= WAITPID;
  return do_waitpid();
}


/*===========================================================================*
 *				do_cpt_setsid				     *
 *===========================================================================*/
int do_cpt_setsid()
{
  assert(mm_call == V7_UNDEFINED_62);

  print_cpt("setsid");

  mm_call= mm_in.m_type= SETSID;
  return do_setsid();
}


/*===========================================================================*
 *				do_cpt_getpgrp				     *
 *===========================================================================*/
int do_cpt_getpgrp()
{
  assert(mm_call == V7_UNDEFINED_63);

  print_cpt("getpgrp");

  mm_call= mm_in.m_type= GETPGRP;
  return do_getpgrp();
}


/*===========================================================================*
 *				do_cpt_sigaction			     *
 *===========================================================================*/
int do_cpt_sigaction()
{
  assert(mm_call == CPT_SIGACTION);

  print_cpt("sigaction");

  mm_call= mm_in.m_type= SIGACTION;
  return do_sigaction();
}


/*===========================================================================*
 *				do_cpt_sigsuspend			     *
 *===========================================================================*/
int do_cpt_sigsuspend()
{
  assert(mm_call == CPT_SIGSUSPEND);

  print_cpt("sigsuspend");

  mm_call= mm_in.m_type= SIGSUSPEND;
  return do_sigsuspend();
}


/*===========================================================================*
 *				do_cpt_sigpending			     *
 *===========================================================================*/
int do_cpt_sigpending()
{
  assert(mm_call == CPT_SIGPENDING);

  print_cpt("sigpending");

  mm_call= mm_in.m_type= SIGPENDING;
  return do_sigpending();
}


/*===========================================================================*
 *				do_cpt_sigprocmask			     *
 *===========================================================================*/
int do_cpt_sigprocmask()
{
  assert(mm_call == CPT_SIGPROCMASK);

  print_cpt("sigmask");

  mm_call= mm_in.m_type= SIGPROCMASK;
  return do_sigprocmask();
}


/*===========================================================================*
 *				do_cpt_sigreturn			     *
 *===========================================================================*/
int do_cpt_sigreturn()
{
  assert(mm_call == CPT_SIGRETURN);

  print_cpt("sigreturn");

  mm_call= mm_in.m_type= SIGRETURN;
  return do_sigreturn();
}


/*===========================================================================*
 *				do_cpt_reboot				     *
 *===========================================================================*/
int do_cpt_reboot()
{
  assert(mm_call == CPT_REBOOT);

  print_cpt("reboot");

  mm_call= mm_in.m_type= REBOOT;
  return do_reboot();
}

/*
 * $PchId: compat.c,v 1.3 1995/11/28 07:19:40 philip Exp $
 */
