#ifndef TYPE_H
#define TYPE_H

typedef _PROTOTYPE( void task_t, (void) );
typedef _PROTOTYPE( void stop_t, (void) );
typedef _PROTOTYPE( int (*rdwt_t), (message *m_ptr) );
typedef _PROTOTYPE( void (*watchdog_t), (void) );

/* Table of kernel tasks. */
struct tasktab {
  task_t *tt_initial_pc;
  stop_t *tt_stop;
  int tt_stksize;
  char *tt_name;
  int tt_proc_no;
};

/* Memory chunks */
typedef struct chunk
{
  phys_clicks chk_base;
  phys_clicks chk_size;
} chunk_t;

/* Administration for clock polling. */
struct micro_state {
  unsigned long accum_count;	/* accumulated clock ticks */
  unsigned prev_count;		/* previous clock value */
  int counting;			/* polling has started? */
};

struct mq;

typedef _PROTOTYPE( void (*reply_func_t), (struct mq *mq, int result, 
						int can_enqueue )	);

#if (CHIP == INTEL)
typedef u16_t port_t;
typedef u16_t segm_t;

typedef U16_t Port_t;
typedef U16_t Segm_t;

typedef unsigned reg_t;		/* machine register */

/* The stack frame layout is determined by the software, but for efficiency
 * it is laid out so the assembly code to use it is as simple as possible.
 * 80286 protected mode and all real modes use the same frame, built with
 * 16-bit registers.  Real mode lacks an automatic stack switch, so little
 * is lost by using the 286 frame for it.  The 386 frame differs only in
 * having 32-bit registers and more segment registers.  The same names are
 * used for the larger registers to avoid differences in the code.
 */
struct stackframe_s {
#if _WORD_SIZE == 4
  u16_t sf_gs;
  u16_t sf_fs;
#endif
  u16_t sf_es;
  u16_t sf_ds;
  reg_t sf_di;			/* di through cx are not accessed in C */
  reg_t sf_si;			/* order is to match pusha/popa */
  reg_t sf_bp;
  reg_t sf_sp_dummy;		/* hole for another copy of sp */
  reg_t sf_bx;
  reg_t sf_dx;
  reg_t sf_cx;
  reg_t sf_ax;
  reg_t sf_pc_save;		/* return address for assembly code save() */
  reg_t sf_pc;			/* interrupt pushes rest of frame */
  reg_t sf_cs;
  reg_t sf_flags;
  reg_t sf_sp;
  reg_t sf_ss;
#if INTEL_32BITS
  u16_t sf_fp_cw;		/* x87/486 control word */
  u16_t sf_fp_res0;		/* intel reserved */
  u16_t sf_fp_sw;		/* x87/486 status word */
  u16_t sf_fp_res1;		/* intel reserved */
  u16_t sf_fp_tw;		/* x87/486 tag word */
  u16_t sf_fp_res2;		/* intel reserved */
  u32_t sf_fp_ip;		/* x87/486 ip of last fp instruction */
  u16_t sf_fp_cs;		/* selector of fp_ip */
  u16_t sf_fp_res3;		/* intel reserved */
  u32_t sf_fp_dp;		/* x87/486 operand ptr of last fp instruction */
  u16_t sf_fp_ds;		/* selector of fp_op */
  u16_t sf_fp_res4;		/* intel reserved */
#else
  reg_t sf_fp_cw;		/* x87/486 control word */
  reg_t sf_fp_sw;		/* x87/486 status word */
  reg_t sf_fp_tw;		/* x87/486 tag word */
  reg_t sf_fp_ip;		/* x87/486 ip of last fp instruction */
  reg_t sf_fp_ip_high;		/* fp_ip bits 15-19 */
  reg_t sf_fp_dp;		/* x87/486 operand ptr of last fp instruction */
  reg_t sf_fp_dp_high;		/* fp_dp bits 15-19 */
#endif
  unsigned char sf_fp_reg[8][10];	/* 8 10-byte fp registers */
  reg_t sf_msw;			/* machine status word, cr0 on a 386 */
};

#define sf_psw		sf_flags
#define sf_retreg	sf_ax
#define sf_fp		sf_bp

struct segdesc_s {		/* segment descriptor for protected mode */
  u16_t limit_low;
  u16_t base_low;
  u8_t base_middle;
  u8_t access;			/* |P|DL|1|X|E|R|A| */
#if INTEL_32BITS
  u8_t granularity;		/* |G|X|0|A|LIMT| */
  u8_t base_high;
#else
  u16_t reserved;
#endif
};

/* Registers used in an PC real mode call for BIOS or DOS services.  A
 * driver is called through the vector if the interrupt number is zero.
 */
union reg86 {
  struct l {
	u32_t	ef;			/* 32 bit flags (output only) */
	u32_t	vec;			/* Driver vector (input only) */
	u32_t	_ds_es[1];
	u32_t	eax;			/* 32 bit general registers */
	u32_t	ebx;
	u32_t	ecx;
	u32_t	edx;
	u32_t	esi;
	u32_t	edi;
	u32_t	ebp;
  } l;
  struct w {
	u16_t	f, _ef[1];		/* 16 bit flags (output only) */
	u16_t	off, seg;		/* Driver vector (input only) */
	u16_t	ds, es;			/* DS and ES real mode segment regs */
	u16_t	ax, _eax[1];		/* 16 bit general registers */
	u16_t	bx, _ebx[1];
	u16_t	cx, _ecx[1];
	u16_t	dx, _edx[1];
	u16_t	si, _esi[1];
	u16_t	di, _edi[1];
	u16_t	bp, _ebp[1];
  } w;
  struct b {
	u8_t	intno, _intno[3];	/* Interrupt number (input only) */
	u8_t	_vec[4];
	u8_t	_ds_es[4];
	u8_t	al, ah, _eax[2];	/* 8 bit general registers */
	u8_t	bl, bh, _ebx[2];
	u8_t	cl, ch, _ecx[2];
	u8_t	dl, dh, _edx[2];
	u8_t	_esi[4];
	u8_t	_edi[4];
	u8_t	_ebp[4];
  } b;
};

typedef _PROTOTYPE( int (*irq_handler_t), (int irq) );
struct irq_ent
{
  unsigned long irq_spur_cnt;
  unsigned long irq_spur_nxt;
};

#endif /* (CHIP == INTEL) */

#if (CHIP == M68000)
typedef _PROTOTYPE( void (*dmaint_t), (void) );

typedef u32_t reg_t;		/* machine register */

/* The name and fields of this struct were chosen for PC compatibility. */
struct stackframe_s {
  reg_t retreg;			/* d0 */
  reg_t d1;
  reg_t d2;
  reg_t d3;
  reg_t d4;
  reg_t d5;
  reg_t d6;
  reg_t d7;
  reg_t a0;
  reg_t a1;
  reg_t a2;
  reg_t a3;
  reg_t a4;
  reg_t a5;
  reg_t fp;			/* also known as a6 */
  reg_t sp;			/* also known as a7 */
  reg_t pc;
  u16_t psw;
  u16_t dummy;			/* make size multiple of reg_t for system.c */
};

struct fsave {
  struct cpu_state {
	u16_t i_format;
	u32_t i_addr;
	u16_t i_state[4];
  } cpu_state;
  struct state_frame {
	u8_t frame_type;
	u8_t frame_size;
	u16_t reserved;
	u8_t frame[212];
  } state_frame;
  struct fpp_model {
	u32_t fpcr;
	u32_t fpsr;
	u32_t fpiar;
	struct fpN {
		u32_t high;
		u32_t low;
		u32_t mid;
	} fpN[8];
  } fpp_model;
};
#endif /* (CHIP == M68000) */

#endif /* TYPE_H */

/*
 * $PchId: type.h,v 1.6 1996/01/19 23:24:37 philip Exp $
 */
