/*
kernel/tty.h

Created:	Feb 26, 1992 by Philip Homburg <philip@cs.vu.nl>
*/

typedef _PROTOTYPE( void (*td_get_t), (int dev_ref)			);
typedef _PROTOTYPE( int (*td_put_t), (int dev_ref, char *buf, int siz)	);
typedef _PROTOTYPE( void (*td_hup_t), (int dev_ref)			);
typedef _PROTOTYPE( void (*td_reply_t), (int dev_ref, mq_t *mq)		);
typedef _PROTOTYPE( void (*td_setattr_t), (int dev_ref, 
						struct termios *tmiop)	);
typedef _PROTOTYPE( void (*td_break_t), (int dev_ref, clock_t dur)	);
typedef _PROTOTYPE( int (*td_putf_t), (struct tty *tty, char *buf,
							int siz)	);

typedef struct tty
{
	/* PUBLIC: call back routines. */
	td_get_t	t_get;
	td_put_t	t_put;
	td_hup_t	t_hup;
	td_reply_t	t_reply;
	td_setattr_t	t_setattr;
	td_break_t	t_break;

	/* PRIVATE */
	int		t_flags;
	int		t_line;
	struct tmrs_context *
			t_tmr_cntxt;

	/* read requests */
	mq_t *		t_rd_queue;
	mq_t *		t_rd_queue_tail;
	unsigned	t_rd_offset;
	phys_bytes	t_rd_phys;
	unsigned	t_rd_size;

	/* write requests */
	mq_t *		t_wr_queue;
	mq_t *		t_wr_queue_tail;
	unsigned	t_wr_offset;
	phys_bytes	t_wr_phys;
	unsigned	t_wr_size;

	/* ioctl requests */
	mq_t *		t_ioc_queue;
	mq_t *		t_ioc_queue_tail;

	int		t_sesldr;
	int		t_opencnt;

	/* input buffer */
	u8_t *		t_rd_buf;
	int		t_rd_buf_siz;
	int		t_rd_begin_n;
	int		t_rd_curr_n;
	int		t_rd_end_n;
	int		t_rd_lineoffs;
	int		t_rd_lnext;
	td_putf_t	t_putf;
	int		t_rd_timer_set;
	clock_t		t_rd_req_time;
	clock_t		t_rd_char_time;
	struct tmrs	t_rd_timer;

	/* output buffer */
	u8_t *		t_wr_buf;
	int		t_wr_buf_siz;
	int		t_wr_begin_n;
	int		t_wr_end_n;
	int		t_wr_position;

	int		t_task;
	struct termios	t_termios;
	struct winsize	t_winsize;
} tty_t;

#define TF_DEV_CLOSED		0x01
#define TF_TTY_CLOSED		0x02
#define TF_READ_INITIATIVE	0x04
#define TF_WRITE_INITIATIVE	0x08
#define TF_XON_OUTPUT_OFF	0x10
#define TF_DRAIN		0x20

/* The minimal size of the input buffer is 257. This 255 bytes {MAX_CANON}
 * plus one byte of the line length and one byte for the length of the next 
 * line. This size is too small for a correct implementation of {MAX_INPUT}.
 * If we are in canonical mode each LF will terminal a line and therefor
 * occupy two bytes, so need a buffer of size 2*{MAX_INPUT}, or 510 bytes
 */
#define T_RD_BUF_SIZ_MIN	257

/* We need at least 8 characters in the output buffer to allow tabs to be
 * expanded.
 */
#define T_WR_BUF_SIZ_MIN	  8

/* The following flags should be implemented by the device driver.
 * 
 * IGNBRK	ignore BREAK condition
 * BRKINT	map BREAK to SIGINTR by calling tty_break_int.
 * IGNPAR	ignore parity errors
 * PARMRK	mark parity and framing errors
 * INPCK	enable checking of parity errors
 * ISTRIP	strip 8th bit
 *
 * CSIZE	character size mask (CS5, CS6, CS7, CS8)
 * CSTOPB	send 2 stop bits
 * PARENB	parity enable
 * PARODD	odd parity, else even
 * CLOCAL	ignore modem status lines.
 */

/*
 * $PchId: tty.h,v 1.4 1995/12/22 08:03:16 philip Exp $
 */
