/*
kernel/timer.h

Definitions and declarations for timer.c

Created:	Jan 19, 1993 by Philip Homburg
*/

#ifndef KERNEL__TIMER_H
#define KERNEL__TIMER_H

typedef union tmr_arg
{
	int ta_int;
	void *ta_ptr;
} tmr_arg_ut;

struct tmra;
typedef void (*tmra_func_ut) _ARGS(( struct tmra *tp, tmr_arg_ut arg ));

typedef struct tmra
{
	int tmra_flags;
	clock_t tmra_exp_time;
	tmra_func_ut tmra_func;
	tmr_arg_ut tmra_arg;
	struct tmra *tmra_next;
} tmra_ut;

#define TAF_SET		0x1

struct tmrs;
typedef void (*tmrs_func_ut) _ARGS(( struct tmrs *tp, tmr_arg_ut arg ));

typedef struct tmrs
{
	int tmrs_flags;
	struct tmrs_context *tmrs_context;
	clock_t tmrs_exp_time;
	tmrs_func_ut tmrs_func;
	tmr_arg_ut tmrs_arg;
	struct tmrs *tmrs_next;
} tmrs_ut;

#define TSF_SET		0x1

typedef struct tmrs_context
{
	tmrs_ut *tsc_chain;
	clock_t tsc_exp_time;
	tmra_ut tsc_timer;
	int *tsc_sig_p;
	int tsc_task;
} tmrs_context_ut;

clock_t tac_exp_time;

void tmra_inittimer _ARGS(( tmra_ut *tp ));
void tmra_settimer _ARGS(( tmra_ut *tp, clock_t exp_time, tmra_func_ut fp, 
							tmr_arg_ut arg ));
void tmra_clrtimer _ARGS(( tmra_ut *tp ));
void tmra_exptimers _ARGS(( void ));
void tmrs_initcontext _ARGS(( tmrs_context_ut *cp, int *sig_p, int task ));
void tmrs_inittimer _ARGS(( tmrs_ut *tp ));
void tmrs_settimer _ARGS(( tmrs_context_ut *cp, tmrs_ut *tp, clock_t exp_time,
					tmrs_func_ut fp, tmr_arg_ut arg ));
void tmrs_clrtimer _ARGS(( tmrs_ut *tp ));
void tmrs_exptimers _ARGS(( tmrs_context_ut *cp ));

#endif /* KERNEL__TIMER_H */

/*
 * $PchId: timer.h,v 1.3 1995/12/22 08:08:07 philip Exp $
 */
