/* The object file of "table.c" contains all the data.  In the *.h files, 
 * declared variables appear with EXTERN in front of them, as in
 *
 *    EXTERN int x;
 *
 * Normally EXTERN is defined as extern, so when they are included in another
 * file, no storage is allocated.  If the EXTERN were not present, but just
 * say,
 *
 *    int x;
 *
 * then including this file in several source files would cause 'x' to be
 * declared several times.  While some linkers accept this, others do not,
 * so they are declared extern when included normally.  However, it must
 * be declared for real somewhere.  That is done here, by redefining
 * EXTERN as the null string, so the inclusion of all the *.h files in
 * table.c actually generates storage for them.  All the initialized
 * variables are also declared here, since
 *
 * extern int x = 4;
 *
 * is not allowed.  If such variables are shared, they must also be declared
 * in one of the *.h files without the initialization.
 */

#define _TABLE

#include "kernel.h"
#include "driver.h"

#define IDLE_NAME	"IDLE"
#define SYS_NAME	"SYS"
#define HARDWARE_NAME	"HARDWARE"
#define MM_NAME		"MM"
#define FS_NAME		"FS"
#define INIT_NAME	"INIT"

/* The startup routine of each task is given below. */

#if CHIP == INTEL && VIRT_MEM
#define SMALL_STACK	4096
#else
#define SMALL_STACK	(256 * sizeof (char *))
#endif

#define DOSDSK_STACK	(SMALL_STACK * ENABLE_DOSDSK)

#define VDISK_STACK	(SMALL_STACK * ENABLE_VDISK)

#define SYN_ALRM_STACK	SMALL_STACK

#define DP8390_STACK	(SMALL_STACK * ENABLE_NETWORKING)

#define CONSOLE_STACK	SMALL_STACK

#define SERIAL_STACK	SMALL_STACK

#define PTY_STACK	SMALL_STACK

#define SCSI_STACK	(SMALL_STACK * ENABLE_SCSI)

#define CDROM_STACK	(SMALL_STACK * ENABLE_CDROM)

#define AUDIO_STACK	(SMALL_STACK * ENABLE_AUDIO)
#define MIXER_STACK	(SMALL_STACK * ENABLE_AUDIO)

#define PAGER_STACK	SMALL_STACK

#if (CHIP == INTEL) && !VIRT_MEM
#define	IDLE_STACK	((3+3+4) * sizeof(char *))  /* 3 intr, 3 temps, 4 db */
#else
#define IDLE_STACK	SMALL_STACK
#endif

#define	PRINTER_STACK	SMALL_STACK

#define	WINCH_STACK	(SMALL_STACK * ENABLE_WINI)

#define	FLOP_STACK	SMALL_STACK
#define	MEM_STACK	SMALL_STACK
#define	CLOCK_STACK	SMALL_STACK
#define	SYS_STACK	SMALL_STACK
#define	HARDWARE_STACK	0		/* dummy task, uses kernel stack */



#define	TOT_STACK_SPACE		(SCSI_STACK + PTY_STACK + \
	PAGER_STACK + DP8390_STACK + CONSOLE_STACK + SERIAL_STACK + \
	SYN_ALRM_STACK + IDLE_STACK + HARDWARE_STACK + PRINTER_STACK + \
	WINCH_STACK + FLOP_STACK + MEM_STACK + CLOCK_STACK + SYS_STACK + \
	DOSDSK_STACK + VDISK_STACK + CDROM_STACK + AUDIO_STACK + MIXER_STACK)


/* SCSI, CDROM and AUDIO may in the future have different choices like
 * WINCHESTER, but for now the choice is fixed.
 */
#define scsi_task	aha_scsi_task
#define cdrom_task	mcd_task
#define audio_task	dsp_task


/* Table of tasks (device drivers).  The fields are:  Task entry point,
 * optional stop function at reboot time, stack size, name used to find it,
 * and task number for the few tasks that are well known.
 */
PUBLIC struct tasktab tasktab[] =
{
  {  idle_task,	    0,		IDLE_STACK,	IDLE_NAME,	IDLE	},
  {  sys_task,	    0,		SYS_STACK,	SYS_NAME,	SYSTASK	},
  {  0,		    0,		HARDWARE_STACK,	HARDWARE_NAME,	HARDWARE },
  {  cons_task,	    cons_stop,	CONSOLE_STACK,	CONS_NAME,	0	},
  {  clock_task,    clock_stop,	CLOCK_STACK,	CLOCK_NAME,	0	},
  {  pager_task,    0,		PAGER_STACK,	PAGER_NAME,	0	},
  {  syn_alrm_task, 0,		SYN_ALRM_STACK, SYN_AL_NAME,	0	},
  {  mem_task,	    0,		MEM_STACK,	MEM_NAME,	0	},
  {  serial_task,   0,		SERIAL_STACK,	SERIAL_NAME,	0	},
  {  pty_task,	    0,		PTY_STACK,	PTY_NAME,	0	},
  {  printer_task,  0,		PRINTER_STACK,	PRINTER_NAME,	0	},
  {  floppy_task,   floppy_stop,FLOP_STACK,	FLOPPY_NAME,	0	},
#if ENABLE_WINI
  {  winchester_task,0,		WINCH_STACK,	WINCHE_NAME,	0	},
#endif
#if ENABLE_SCSI
  {  scsi_task,	    0,		SCSI_STACK,	SCSI_NAME,	0	},
#endif
#if ENABLE_CDROM
  {  cdrom_task,    0,		CDROM_STACK,	CDROM_NAME,	0	},
#endif
#if ENABLE_DOSDSK
  {  dosdsk_task,   0,		DOSDSK_STACK,	DOSDSK_NAME,	0	},
#endif
#if ENABLE_VDISK
  {  vdisk_task,    0,		VDISK_STACK,	VDISK_NAME,	0	},
#endif
#if ENABLE_NETWORKING
  {  dp8390_task,   dp8390_stop,DP8390_STACK,	DP8390_NAME,	0	},
#endif
#if ENABLE_AUDIO
  {  audio_task,    0,		AUDIO_STACK,	AUDIO_NAME,	0	},
  {  mixer_task,    0,		MIXER_STACK,	MIXER_NAME,	0	},
#endif
  /* End of the table, indicated by a NULL pointer instead of a name */
  {  0,		    0,		0,		NULL,		0	},
};

/* Stack space for all the task stacks.  (Declared as (char *) to align it.) */
PUBLIC char *t_stack[TOT_STACK_SPACE / sizeof(char *)];
PUBLIC int clck_tasknr= ANY;

/*
 * $PchId: table.c,v 1.4 1995/12/22 08:08:52 philip Exp $
 */
