/*	synch.h - kernel process synchronization.	Author: Kees J. Bot
 *								16 Nov 1993
 *
 * These functions provide mutexes and conditions to Minix kernel threads.
 * This allows drivers to lock shared hardware resources.  (These functions
 * are not that useful given that kernel threads are not pre-empted.  The
 * VM system can make use of them a bit, with all those random faults.  More
 * may follow.)
 */

/* Mutual exclusion and condition variables, simply pointers to a queue of
 * waiting processes.
 */
typedef struct proc *mutex_t, *cond_t;

/* Sync messages sent are of type THREAD_SYNCH.  The m1_p1 field holds the
 * address of the variable unlocked or signalled.  This is only for concistency
 * checking, because a thread can only be blocked on one specific variable,
 * and can therefore only be signalled on that variable.
 */

/* Mutex primitives. */
#define mutex_init(mvp)		((void) ((*mvp) = NULL))
#define mutex_destroy(mvp)	((void) (*(mvp))->p_nr)
int mutex_lock(mutex_t *mvp);
int mutex_unlock(mutex_t *mvp);
int mutex_trylock(mutex_t *mvp);

/* Condition primitives. */
#define cond_init(cvp)		((void) ((*cvp) = NULL))
#define cond_destroy(cvp)	((void) (*(cvp))->p_synchqueue)
int cond_wait(cond_t *cvp, mutex_t *mvp, mq_t **pmq);
int cond_signal(cond_t *cvp);
int cond_broadcast(cond_t *cvp);

/*
 * $PchId: synch.h,v 1.3 1995/12/22 08:15:17 philip Exp $
 */
