/* Function prototypes. */

#ifndef PROTO_H
#define PROTO_H

/* Struct declarations. */
struct dpeth;
struct mq;
struct proc;
struct tmrs_context;
struct tty;
struct timeval;
struct kio_map;

/* aha_scsi.c */
_PROTOTYPE( void aha_scsi_task, (void)					);

/* wini.c, at_wini.c, bios_wini.c, esdi_wini.c, xt_wini.c */
_PROTOTYPE( void winchester_task, (void)				);
_PROTOTYPE( void at_winchester_task, (void)				);
_PROTOTYPE( void bios_winchester_task, (void)				);
_PROTOTYPE( void esdi_winchester_task, (void)				);
_PROTOTYPE( void xt_winchester_task, (void)				);
_PROTOTYPE( void st_winchester_task, (void)				);

/* clock.c */
_PROTOTYPE( void clock_task, (void)					);
_PROTOTYPE( void clock_stop, (void)					);
_PROTOTYPE( clock_t get_uptime, (void)					);
_PROTOTYPE( void syn_alrm_task, (void)					);

/* dmp.c, stdmp.c */
_PROTOTYPE( void map_dmp, (void)					);
_PROTOTYPE( void p_dmp, (void)						);
_PROTOTYPE( void sched_dmp, (void)						);
_PROTOTYPE( void reg_dmp, (struct proc *rp)				);
_PROTOTYPE( void tty_dmp, (void)					);
_PROTOTYPE( void stacktrace, (struct proc *pp)				);
_PROTOTYPE( void loadav_dmp, (void)					);

/* dosdsk.c */
_PROTOTYPE( void dosdsk_task, (void)					);

/* floppy.c, stfloppy.c */
_PROTOTYPE( void floppy_task, (void)					);
_PROTOTYPE( void floppy_stop, (void)					);

#if _PKG_LOG
/* log.c */
_PROTOTYPE( void log_init, (void)					);
_PROTOTYPE( void log_stop, (void)					);
_PROTOTYPE( void log_setreply, (reply_func_t reply_func, int task_nr)	);
_PROTOTYPE( void log_mess, (struct mq *mq)				);
_PROTOTYPE( void log_int, (void)					);
_PROTOTYPE( int log_print, (vir_bytes buf, vir_bytes size,
							int proc_nr)	);
_PROTOTYPE( void log_put, (char *buf, unsigned size, int proc_nr)	);
_PROTOTYPE( void log_append, (char *buf, unsigned size)			);
#endif /* _PKG_LOG */

/* main.c, stmain.c */
_PROTOTYPE( void main, (void)						);
_PROTOTYPE( void panic, (const char *s, int n)				);

/* mcd.c */
_PROTOTYPE( void mcd_task, (void)					);

/* memory.c */
_PROTOTYPE( void mem_task, (void)					);

/* misc.c */
_PROTOTYPE( void chunk_add, (phys_clicks base, phys_clicks size)	);
_PROTOTYPE( void chunk_del, (phys_clicks base, phys_clicks size)	);
_PROTOTYPE( int chunk_find, (phys_clicks *base, phys_clicks *size)	);
_PROTOTYPE( int env_parse, (char *env, char *fmt, int field,
		long *param, long min, long max)				);

/* printer.c, stprint.c */
_PROTOTYPE( void printer_task, (void)					);

/* proc.c */
_PROTOTYPE( void interrupt, (int task)					);
_PROTOTYPE( void lock_pick_proc, (void)					);
_PROTOTYPE( void lock_ready, (struct proc *rp)				);
_PROTOTYPE( void lock_sched, (void)					);
_PROTOTYPE( void lock_unready, (struct proc *rp)			);
_PROTOTYPE( void lock_dequeue, (struct proc *rp)			);
_PROTOTYPE( int check_proc_ptr, (void)					);
_PROTOTYPE( void sys_call, (struct proc *rp, int function,
					int src_dest, vir_bytes m_vir)	);
_PROTOTYPE( void sys_restart, (struct proc *rp)				);
_PROTOTYPE( void unhold, (void)						);
_PROTOTYPE( void print_procinfo, (void)					);
_PROTOTYPE( void print_unready, (void)					);

/* profile.c */
_PROTOTYPE( void profile, (struct proc *pp)				);
_PROTOTYPE( void prof_stop, (void)					);
_PROTOTYPE( void profile_init, (reply_func_t reply_func, int task_nr)	);
_PROTOTYPE( void profile_mess, (struct mq *mq)				);
_PROTOTYPE( void profile_int, (void)					);

/* pty.c */
_PROTOTYPE( void pty_task, (void)					);

#if _PKG_RAWKBD
/* rawkbd.c */
_PROTOTYPE( void rawkbd_init, (reply_func_t reply_func, int task_nr)	);
_PROTOTYPE( void rawkbd_mess, (struct mq *mq)				);
_PROTOTYPE( void kbdaux_mess, (struct mq *mq)				);
_PROTOTYPE( void rawkbd_int, (void)					);
_PROTOTYPE( void rawkbd_put, (char *buf, unsigned size)			);
_PROTOTYPE( void kbdaux_put, (char *buf, unsigned size)			);
#endif /* _PKG_RAWKBD */

/* rs232.c */
_PROTOTYPE( void serial_task, (void)					);
_PROTOTYPE( int ser_nextline, (void)					);
_PROTOTYPE( void ser_putk, (int c)					);

/* sb16_dsp.c */
_PROTOTYPE( void dsp_task, (void)					);

/* sb16_mixer.c */
_PROTOTYPE( void mixer_task, (void)					);

/* system.c */
_PROTOTYPE( void cause_sig, (int proc_nr, int sig_nr)			);
_PROTOTYPE( phys_bytes numap, (int proc_nr, vir_bytes vir_addr, 
		vir_bytes bytes)					);
_PROTOTYPE( void sys_task, (void)					);
_PROTOTYPE( phys_bytes umap, (struct proc *rp, int seg, vir_bytes vir_addr,
		vir_bytes bytes)					);
_PROTOTYPE( int findproc, (char *name)					);

/* tty.c */
_PROTOTYPE( void tty_init, (struct tty *tty, int dev_ref,
		char *readbuf, int readbuf_siz, char *writebuf,
		int writebuf_siz, int task, struct tmrs_context *cntxt)	);
_PROTOTYPE( void tty_receive, (struct tty *tty, struct mq *mq)	);
_PROTOTYPE( void tty_get, (struct tty *tty)				);
_PROTOTYPE( void tty_hup, (struct tty *tty)				);
_PROTOTYPE( int tty_put, (struct tty *tty, char *buf, int siz)	);
_PROTOTYPE( void tty_break_int, (struct tty *tty)			);

#if (CHIP == INTEL)

/* clock.c */
_PROTOTYPE( void micro_init, (struct timeval *tvp)			);
_PROTOTYPE( unsigned long micro_elapsed, (struct timeval *tvp)		);
_PROTOTYPE( void micro_delay, (unsigned long usecs)			);

/* console.c */
_PROTOTYPE( void cons_task, (void)					);
_PROTOTYPE( void cons_stop, (void)					);
_PROTOTYPE( void putk, (int c)						);
_PROTOTYPE( void scr_init, (int minor)					);
_PROTOTYPE( void toggle_scroll, (void)					);
_PROTOTYPE( void cons_print, (char *buf, unsigned size)			);
_PROTOTYPE( void enable_video, (int on)					);
_PROTOTYPE( void console_hotkey, (char *key)				);
_PROTOTYPE( void show_event, (int ev, int /* char */ code)		);

/* dp8390.c */
_PROTOTYPE( void dp8390_task, (void)					);
_PROTOTYPE( void dp_dump, (void)					);
_PROTOTYPE( void dp8390_stop, (void)					);

/* start.c */
_PROTOTYPE( void cstart, (U16_t cs, U16_t ds, U16_t mcs, U16_t mds,
				U16_t parmoff, U16_t parmsize)		);
_PROTOTYPE( char *k_getenv, (char *name)				);

/* exception.c */
_PROTOTYPE( void exception, (unsigned ex_number, u32_t trap_errno, 
			u32_t old_eip, U16_t old_cs, u32_t old_eflags)	);

/* i387.c */
_PROTOTYPE( void fpu_init, (void)					);
_PROTOTYPE( void fpu_switch, (void)					);
_PROTOTYPE( int fpu_exception, (int irq)				);


/* i387.s */
_PROTOTYPE( void fpu_save, (void)					);
_PROTOTYPE( void fpu_store, (void)					);
_PROTOTYPE( void fpu_empty, (void)					);
_PROTOTYPE( void fpu_reload, (void)					);
_PROTOTYPE( int fpu_probe, (void)					);
_PROTOTYPE( int fpu_fdiv_test, (void)					);

/* i8259.c */
_PROTOTYPE( irq_handler_t get_irq_handler, (int irq)			);
_PROTOTYPE( void put_irq_handler, (int irq, irq_handler_t handler)	);
_PROTOTYPE( void intr_init, (int mine)					);

/* keyboard.c */
_PROTOTYPE( void kb_init, (int minor, int task_nr)			);
_PROTOTYPE( int kb_read, (unsigned char **bufindirect)			);
_PROTOTYPE( int kb_translate, (int code, unsigned char **bufp)		);
_PROTOTYPE( void wreboot, (int how)					);
_PROTOTYPE( void kbd_set_leds, (unsigned leds)				);
_PROTOTYPE( void kbd_bell, (unsigned pitch, unsigned duration)		);
_PROTOTYPE( int kbd_aux, (int enable)					);
_PROTOTYPE( int kbd_loadmap, (struct kio_map *maphdr, int proc)		);

/* klib*.x */
_PROTOTYPE( void int86, (void)						);
_PROTOTYPE( void build_sig, (char *sig_stuff, struct proc *rp, int sig)	);
_PROTOTYPE( phys_bytes check_mem, (phys_bytes base, phys_bytes size)	);
_PROTOTYPE( void cpmess_unchecked, (phys_bytes dst, phys_bytes src,
							int src_proc)	);
_PROTOTYPE( void cpmess_end, (void)					);
_PROTOTYPE( int in_byte, (Port_t port)					);
_PROTOTYPE( int in_word, (Port_t port)					);
_PROTOTYPE( void lock, (void)						);
_PROTOTYPE( void unlock, (void)						);
_PROTOTYPE( void enable_irq, (unsigned irq)				);
_PROTOTYPE( int disable_irq, (unsigned irq)				);
_PROTOTYPE( U16_t mem_rdw, (Segm_t segm, vir_bytes offset)		);
_PROTOTYPE( void out_byte, (Port_t port, int value)			);
_PROTOTYPE( void out_word, (Port_t port, int value)			);
_PROTOTYPE( void phys_copy, (phys_bytes source, phys_bytes dest,
		phys_bytes count)					);
_PROTOTYPE( void phys_zero, (phys_bytes dest, phys_bytes count)		);
_PROTOTYPE( void port_read, (unsigned port, phys_bytes destination,
		unsigned bytcount)					);
_PROTOTYPE( void port_read_byte, (unsigned port, phys_bytes destination,
		unsigned bytcount)					);
_PROTOTYPE( void port_write, (unsigned port, phys_bytes source,
		unsigned bytcount)					);
_PROTOTYPE( void port_write_byte, (unsigned port, phys_bytes source,
		unsigned bytcount)					);
_PROTOTYPE( void reset, (void)						);
_PROTOTYPE( void vid_vid_copy, (unsigned src, unsigned dst, unsigned count));
_PROTOTYPE( void mem_vid_copy, (u16_t *src, unsigned dst, unsigned count));
_PROTOTYPE( reg_t get_bp, (void)					);
_PROTOTYPE( reg_t get_msw, (void)					);
_PROTOTYPE( void set_msw, (reg_t msw)					);
_PROTOTYPE( void level0, (void (*func)(void))				);
_PROTOTYPE( void monitor, (void)					);

/* misc.c */
_PROTOTYPE( void mem_init, (void)					);

/* mpx*.x */
_PROTOTYPE( void idle_task, (void)					);
_PROTOTYPE( void restart, (void)					);

/* The following are never called from C (pure asm procs). */
_PROTOTYPE( void minix_crtso, (void)					);

/* Exception handlers, in numerical order. */
_PROTOTYPE( void divide_error, (void) );
_PROTOTYPE( void single_step_exception, (void) );
_PROTOTYPE( void nmi, (void) );
_PROTOTYPE( void breakpoint_exception, (void) );
_PROTOTYPE( void overflow, (void) );
_PROTOTYPE( void bounds_check, (void) );
_PROTOTYPE( void inval_opcode, (void) );
_PROTOTYPE( void copr_not_available, (void) );
_PROTOTYPE( void double_fault, (void) );
_PROTOTYPE( void copr_seg_overrun, (void) );
_PROTOTYPE( void inval_tss, (void) );
_PROTOTYPE( void segment_not_present, (void) );
_PROTOTYPE( void stack_exception, (void) );
_PROTOTYPE( void general_protection, (void) );
_PROTOTYPE( void page_fault, (void) );
_PROTOTYPE( void floating_point_exception, (void) );
_PROTOTYPE( void alignment_check, (void) );

/* Hardware interrupt handlers, in numerical order. */
_PROTOTYPE( void hwint00, (void) );
_PROTOTYPE( void hwint01, (void) );
_PROTOTYPE( void hwint02, (void) );
_PROTOTYPE( void hwint03, (void) );
_PROTOTYPE( void hwint04, (void) );
_PROTOTYPE( void hwint05, (void) );
_PROTOTYPE( void hwint06, (void) );
_PROTOTYPE( void hwint07, (void) );
_PROTOTYPE( void hwint08, (void) );
_PROTOTYPE( void hwint09, (void) );
_PROTOTYPE( void hwint10, (void) );
_PROTOTYPE( void hwint11, (void) );
_PROTOTYPE( void hwint12, (void) );
_PROTOTYPE( void hwint13, (void) );
_PROTOTYPE( void hwint14, (void) );
_PROTOTYPE( void hwint15, (void) );

/* Software interrupt handlers, in numerical order. */
_PROTOTYPE( void trp, (void) );
_PROTOTYPE( void s_call, (void) );
_PROTOTYPE( void level0_call, (void) );

/* ne2000.c */
_PROTOTYPE( int ne_probe, (struct dpeth *dep)				);

/* protect.c */
_PROTOTYPE( void prot_init, (void)					);
_PROTOTYPE( void init_codeseg, (struct segdesc_s *segdp, 
	phys_bytes base, phys_bytes size, int privilege)		);
_PROTOTYPE( void init_dataseg, (struct segdesc_s *segdp, 
	phys_bytes base, phys_bytes size, int privilege)		);
_PROTOTYPE( phys_bytes seg2phys, (U16_t seg)				);
_PROTOTYPE( void enable_iop, (struct proc *pp)				);

/* system.c */
_PROTOTYPE( void alloc_segments, (struct proc *rp)			);

/* vdisk.c */
_PROTOTYPE( void vdisk_task, (void)					);

/* vga.c */
_PROTOTYPE( void vga_init, (reply_func_t reply_func)			);
_PROTOTYPE( void vga_mess, (struct mq *mq)				);

#if VIRT_MEM
/* vm386.c */
_PROTOTYPE( void vm_dump, (void)					);
_PROTOTYPE( void vm_init, (void)					);
_PROTOTYPE( void vm_map_zp, (int map_page)				);
_PROTOTYPE( u32_t vm_alloc_space, (struct proc *pp, u32_t size)		);
_PROTOTYPE( void vm_map_image, (struct proc *pp, u32_t vir_base, 
					u32_t img_base, u32_t size)	);
_PROTOTYPE( void vm_make_clear, (struct proc *pp, u32_t base, u32_t size));
_PROTOTYPE( int vm_ismapped, (u32_t addr)				);
_PROTOTYPE( int vm_phys2bus, (struct proc *pp, u32_t *tab, size_t tabsize));
_PROTOTYPE( u32_t vm_1phys2bus, (u32_t phys)				);
#if PAGING_VM
_PROTOTYPE( void pager_task, (void)					);
_PROTOTYPE( void vm_check_unmapped, (phys_clicks base_clicks,
					 phys_clicks size_clicks)	);
_PROTOTYPE( void vm_lock_hardware, (phys_bytes phys_base, 
						phys_bytes phys_size)	);
_PROTOTYPE( void vm_map_hardware, (phys_bytes hw_addr,
			phys_bytes phys_base, phys_bytes phys_size)	);
_PROTOTYPE( void vm_unmap_space, (phys_bytes phys_base, 
						phys_bytes phys_size)	);
_PROTOTYPE( void vm_unmap_pages, (phys_bytes phys_base, 
						phys_bytes phys_size)	);
_PROTOTYPE( void vm_remap_space, (phys_bytes phys_base, 
			phys_bytes phys_size, int srcproc, int dstproc)	);
_PROTOTYPE( void vm_remap_pages, (phys_bytes phys_base, 
			phys_bytes phys_size, int srcproc, int dstproc)	);
_PROTOTYPE( void vm_allocmap, (struct proc *pp, phys_clicks base_clicks,
					phys_clicks size_clicks)	);
_PROTOTYPE( void vm_fork, (phys_clicks source_clicks,
	phys_clicks dest_clicks, phys_clicks size_clicks, int ro)	);
_PROTOTYPE( void vm_page_fault, (u32_t err, u32_t addr,
					struct proc *fault_proc)	);
_PROTOTYPE( int vm_check_stats, (void)					);
_PROTOTYPE( int vm_hard_check_stats, (void)				);
_PROTOTYPE( int vm_swapon, (int pnr, int minor, u32_t offset, 
					u32_t size, i32_t priority)	);
_PROTOTYPE( int vm_swapoff, (int segm)					);
_PROTOTYPE( int vm_swapinfo, (int pnr, int minor, i32_t *index_p)	);
_PROTOTYPE( u32_t vm_check_addr, (phys_bytes addr, phys_bytes size)	);
_PROTOTYPE( void vm_suspend, (struct proc *pp, u32_t addr)		);
_PROTOTYPE( void vm_dequeue, (struct proc *pp)				);
_PROTOTYPE( int vm_lock, (phys_bytes phys_addr, phys_bytes phys_count,
							int force_loc)	);
_PROTOTYPE( void vm_unlock, (phys_bytes phys_addr,
						phys_bytes phys_count)	);
#else /* !PAGING_VM */
_PROTOTYPE( void vm_fork, (struct proc *parent, phys_clicks child_base)	);
_PROTOTYPE( void vm_check_unmapped, (phys_bytes base, phys_bytes top)	);
_PROTOTYPE( void vm_unmap, (phys_bytes addr, phys_bytes vm_size,
		phys_clicks alloc_size)						);
_PROTOTYPE( void vm_page_fault, (u32_t err, phys_bytes addr)		);
#endif /* PAGING_VM */

/* vm386.ack.s */
_PROTOTYPE( int _get_phys_byte, (phys_bytes addr)			);
_PROTOTYPE( u32_t _get_phys_dword, (phys_bytes addr)			);
_PROTOTYPE( void phys_clr_page, (phys_bytes addr)			);
_PROTOTYPE( phys_bytes phys_zero_scan, (phys_bytes table_base,
		phys_bytes table_size)						);
_PROTOTYPE( void _put_phys_byte, (phys_bytes addr, int byte)		);
_PROTOTYPE( void _put_phys_dword, (phys_bytes addr, u32_t dword)		);
_PROTOTYPE( void vm_enable, (phys_bytes page_base)			);
_PROTOTYPE( void vm_reload, (void)					);
#endif /* VIRT_MEM */

/* wdeth.c */
_PROTOTYPE( int wdeth_probe, (struct dpeth *dep)			);

#endif /* (CHIP == INTEL) */

#if (CHIP == M68000)

/* stfloppy.c */
_PROTOTYPE( void fd_timer, (void)					);

/* stmain.c */
_PROTOTYPE( void none, (void)						);
_PROTOTYPE( void rupt, (void)						);
_PROTOTYPE( void trap, (void)						);
_PROTOTYPE( void checksp, (void)					);
_PROTOTYPE( void aciaint, (void)					);
_PROTOTYPE( void fake_int, (char *s, int t)				);
_PROTOTYPE( void timint, (int t)					);
_PROTOTYPE( void mdiint, (void)						);
_PROTOTYPE( void iob, (int t)						);
_PROTOTYPE( void idle_task, (void)					);

/* rs232.c */
_PROTOTYPE( void siaint, (int type)					);

/* stcon.c */
_PROTOTYPE( void func_key, (void)					);
_PROTOTYPE( void dump, (void)						);
_PROTOTYPE( void putk, (int c)						);

/* stdma.c */
_PROTOTYPE( void dmagrab, (int p, dmaint_t func)			);
_PROTOTYPE( void dmafree, (int p)					);
_PROTOTYPE( void dmaint, (void)						);
_PROTOTYPE( void dmaaddr, (phys_bytes ad)				);
_PROTOTYPE( int dmardat, (int mode, int delay)				);
_PROTOTYPE( void dmawdat, (int mode, int data, int delay)		);
_PROTOTYPE( void dmawcmd, (int data, unsigned mode)			);
_PROTOTYPE( void dmacomm, (int mode, int data, int delay)		);
_PROTOTYPE( int dmastat, (int mode, int delay)				);

/* stdskclk.c */
_PROTOTYPE( int do_xbms, (phys_bytes address, int count, int rw, int minor) );
 
/* stkbd.c */
_PROTOTYPE( void kbdint, (void)						);
_PROTOTYPE( void kb_timer, (void)					);
_PROTOTYPE( int kb_read, (int minor, char **bufindirect,
		unsigned char *odoneindirect)				);
_PROTOTYPE( void kbdinit, (int minor)					);

/* stshadow.c */
_PROTOTYPE( void mkshadow, (struct proc *p, phys_clicks c2)		);
_PROTOTYPE( void rmshadow, (struct proc *p, phys_clicks *basep,
		phys_clicks *sizep)					);
_PROTOTYPE( void unshadow, (struct proc *p)				);
 
/* stvdu.c */
_PROTOTYPE( void flush, (struct tty_struct *tp)				);
_PROTOTYPE( void console, (struct tty_struct *tp)			);
_PROTOTYPE( void out_char, (struct tty_struct *tp, int c)		);
_PROTOTYPE( void vduinit, (struct tty_struct *tp)			);
_PROTOTYPE( void vduswitch, (struct tty_struct *tp)			);
_PROTOTYPE( int vdu_loadfont, (message *m_ptr)				);

/* copy68k.s */
_PROTOTYPE( void flipclicks, (phys_clicks c1, phys_clicks c2, phys_clicks n) );
_PROTOTYPE( void copyclicks, (phys_clicks src, phys_clicks dest,
		phys_clicks nclicks)					);
_PROTOTYPE( void zeroclicks, (phys_clicks dest, phys_clicks nclicks)	);
_PROTOTYPE( void phys_copy, (phys_bytes src, phys_bytes dest, phys_bytes n) );

/* stdmp.c */
_PROTOTYPE( void reg_dmp, (struct proc *rp)				);

/* stdskclks.s */
_PROTOTYPE( int rd1byte, (void)						);
_PROTOTYPE( int wr1byte, (int)						);
_PROTOTYPE( long getsupra, (void)					);
_PROTOTYPE( long geticd, (void)						);

/* stmpx.s */
_PROTOTYPE( int lock, (void)						);
_PROTOTYPE( void unlock, (void)						);
_PROTOTYPE( void restore, (int oldsr)					);
_PROTOTYPE( void reboot, (void)						);
_PROTOTYPE( int test_and_set, (char *flag)				);

/* stprint.c */
#ifdef DEBOUT
_PROTOTYPE( void prtc, (int c)						);
#endif

#endif /* (CHIP == M68000) */

#endif /* PROTO_H */

/*
 * $PchId: proto.h,v 1.6 1996/03/12 22:16:24 philip Exp $
 */
