/*
kernel/mq.h

Created:	Jan 3, 1992 by Philip Homburg
*/

#ifndef INET__MQ_H
#define INET__MQ_H

typedef struct mq
{
	message mq_mess;
	struct mq *mq_next;
	int mq_allocated;

#ifdef MQ_TRACK_ALLOC_FREE
	char *mq_file;
	int mq_line;
#endif
} mq_t;

_PROTOTYPE( mq_t *mq_get, (void) );
_PROTOTYPE( void mq_free, (mq_t *mq) );
_PROTOTYPE( void mq_init, (void) );

#ifdef MQ_TRACK_ALLOC_FREE
_PROTOTYPE( mq_t *_mq_get, (char *file, int line) );
_PROTOTYPE( void _mq_mark, (mq_t *mq, char *file, int len) );
#define mq_get() (_mq_get(__FILE__, __LINE__))
#define mq_mark(mq) (_mq_mark(mq, __FILE__, __LINE__))
#endif

#endif /* INET__MQ_H */

/*
 * $PchId: mq.h,v 1.4 1996/01/19 23:27:01 philip Exp $
 */
