/*
kernel/mq.c

Created:	Jan 3, 1992 by Philip Homburg
*/

#include "kernel.h"
#include "assert.h"
INIT_ASSERT
#include "mq.h"

#define MQ_SIZE		64

PRIVATE mq_t mq_list[MQ_SIZE];
PRIVATE mq_t *mq_freelist;

void mq_init()
{
	int i;

	mq_freelist= NULL;
	for (i= 0; i<MQ_SIZE; i++)
	{
		mq_list[i].mq_next= mq_freelist;
		mq_freelist= &mq_list[i];
		mq_list[i].mq_allocated= 0;
	}
}

#ifndef MQ_TRACK_ALLOC_FREE
mq_t *mq_get()
{
	mq_t *mq;

	mq= mq_freelist;
	assert(mq);
	mq_freelist= mq->mq_next;
	mq->mq_next= NULL;

	assert(mq->mq_allocated == 0);
	mq->mq_allocated= 1;
	return mq;
}
#else
mq_t *_mq_get(file, line)
char *file;
int line;
{
	mq_t *mq;

	mq= mq_freelist;
	if (!mq)
	{
		int i;
		for (i= 0; i<MQ_SIZE; i++)
		{
			printf("%s,%d ", mq_list[i].mq_file, 
				mq_list[i].mq_line);
		}
	}
	assert(mq);
	mq_freelist= mq->mq_next;
	mq->mq_next= NULL;

	assert(mq->mq_allocated == 0);
	mq->mq_allocated= 1;
	mq->mq_file= file;
	mq->mq_line= line;
	return mq;
}

void _mq_mark(mq, file, line)
mq_t *mq;
char *file;
int line;
{
	mq->mq_file= file;
	mq->mq_line= line;
}
#endif

void mq_free(mq)
mq_t *mq;
{
	mq->mq_next= mq_freelist;
	mq_freelist= mq;
	assert(mq->mq_allocated == 1);
	mq->mq_allocated= 0;
}

/*
 * $PchId: mq.c,v 1.4 1996/01/19 23:27:01 philip Exp $
 */
