/*
vm386.h

Created 1991-Apr-23 by Philip Homburg
*/

#ifndef VM386_H
#define VM386_H

#define VM_PRESENT	0x1
#define VM_WRITE	0x2
#define VM_USER		0x4
/* #define VM_PWT	0x8 */
#define VM_PCD		0x10
#define VM_ACCESSED	0x20
/* #define VM_DIRTY	0x40 */
/* #define VM_RESERVED	0x80 */
/* #define VM_RESERVED	0x100 */
#define VM_HARDWARE	0x200		/* VM_OS */
/* #define VM_OS	0x400 */
/* #define VM_OS	0x800 */

#if PAGING_VM
#define VM_SWAPPAGE	0x80000000
#else /* !PAGING_VM */
#define VM_INMEM	0x200
#define VM_INMEM_N_PRESENT	(VM_INMEM | VM_PRESENT)
#define VM_IM_RW_PRES	(VM_INMEM | VM_WRITE | VM_PRESENT)
#endif /* PAGING_VM */

#define VM_ADDRMASK	0xfffff000
#define VM_DIRMASK	0x003fffff
#define VM_PAGEMASK	0x00000fff

#define VM_PAGESIZE	0x1000
#define VM_DIRSIZE	0x400000
#define VM_PAGESHIFT	12	/* 2log VM_PAGESIZE */
#define VM_DIRSHIFT	22	/* 2log VM_DIRSIZE */

#define vm_addr_to_page(a)	((a >> VM_PAGESHIFT) & 0x3ff)
#define vm_addr_to_dir(a)	((a >> VM_DIRSHIFT) & 0x3ff)

#define VM_ISA_LIMIT	0x1000000

#if DEBUG & 256
/* debug */
#undef VM_ISA_LIMIT
#define VM_ISA_LIMIT	0x600000
#endif

#if VMDEXT_KERNEL_LINMAP
#define get_phys_byte(a)	(*(u8_t *)(a))
#define get_phys_dword(a)	(*(u32_t *)(a))
#define put_phys_byte(a,d)	(*(u8_t *)(a)=(d),(void)0)
#define put_phys_dword(a,d)	(*(u32_t *)(a)=(d),(void)0)
#else /* !VMDEXT_KERNEL_LINMAP */
#endif /* VMDEXT_KERNEL_LINMAP */

#endif /* VM386_H */

/*
 * $PchId: vm386.h,v 1.4 1995/12/22 09:36:22 philip Exp $
 */
