#
! vm386.ack.s
!
! This file contains assembler routines for the 386 virtual memory management
!
! Created 1991-Apr-23 by Philip Homburg
!

#include <minix/cfg_public.h>
#include <minix/const.h>
#include "protect.h"
#include "const.h"

#define CR0_PG			0x80000000

! Sections
.sect .text; .sect .rom; .sect .data; .sect .bss

! Exported routines
.sect .text
#if !VMDEXT_KERNEL_LINMAP
.define __put_phys_byte
.define __get_phys_byte
.define __put_phys_dword
.define __get_phys_dword
#endif
.define _phys_zero_scan
.define _vm_enable
.define _vm_reload
.define _phys_clr_page

.sect .text

#if !VMDEXT_KERNEL_LINMAP

! void _put_phys_byte (phys_bytes phys_addr, int byte);

	.align	16
__put_phys_byte:
	push	ebx
	push	ds
	mov	eax, FLAT_DS_SELECTOR
	mov	ds, ax
	mov	eax, 4+12(esp)		! byte
	mov	ebx, 0+12(esp)		! phys_addr
	movb	(ebx), al
	pop	ds
	pop	ebx
	ret

! int _get_phys_byte (phys_bytes phys_addr);

	.align	16
__get_phys_byte:
	push	ebx
	push	ds
	mov	eax, FLAT_DS_SELECTOR
	mov 	ds, ax
	mov	ebx, 0+12(esp)		! phys_addr
	movzxb	eax, (ebx)
	pop	ds
	pop	ebx
	ret
	
! void _put_phys_dword (phys_bytes phys_addr, u32_t dword);

	.align	16
__put_phys_dword:
	push	ebx
	push	ds
	mov	eax, FLAT_DS_SELECTOR
	mov	ds, ax
	mov	eax, 4+12(esp)		! dword
	mov	ebx, 0+12(esp)		! phys_addr
	mov	(ebx), eax
	pop	ds
	pop	ebx
	ret

! u32_t _get_phys_dword (phys_bytes phys_addr);

	.align	16
__get_phys_dword:
	push	ebx
	push	ds
	mov	eax, FLAT_DS_SELECTOR
	mov 	ds, ax
	mov	ebx, 0+12(esp)		! phys_addr
	mov	eax, (ebx)
	pop	ds
	pop	ebx
	ret

# endif /* !VMDEXT_KERNEL_LINMAP */
	
! phys_bytes phys_zero_scan (phys_bytes table_base, phys_bytes table_size);

	.align	16
_phys_zero_scan:
	push	edi
	push	ecx
	push	es
	mov	edi, 0+16(esp)		! table_base
	mov	ecx, 4+16(esp)		! table_size
	mov	eax, FLAT_DS_SELECTOR
	mov	es, ax
	xorb	al, al
	cld
	repne
	scasb				! Search 0 byte in [ES:EDI]
	mov	eax, edi
	dec	eax
	pop	es
	pop	ecx
	pop	edi
	ret

! void vm_enable(phys_bytes page_base)

_vm_enable:
	mov	eax, 0+4(esp)		! page_base
	mov	cr3, eax
	
	mov	eax, cr0
	or	eax, CR0_PG
	mov	cr0, eax
	ret

! void vm_reload(void)

_vm_reload:
	mov	eax, cr3
	mov	cr3, eax
	ret

! void phys_clr_page (phys_bytes addr);

	.align	16
_phys_clr_page:
	push	edi
	push	ecx
	push	es
	mov	eax, FLAT_DS_SELECTOR
	mov 	es, ax
	mov	edi, 0+16(esp)		! addr
	xor	eax, eax
	mov	ecx, CLICK_SIZE>>2
	cld
	rep
	stos
	pop	es
	pop	ecx
	pop	edi
	ret

!
! $PchId: vm386.ack.s,v 1.4 1995/12/22 09:39:51 philip Exp $
!
