/* Constants for protected mode. */

/* Table sizes. */
#define GDT_SIZE (FIRST_LDT_INDEX + NR_TASKS + NR_PROCS) /* spec. and LDT's */
#define IDT_SIZE (IRQ8_VECTOR + 8)	/* only up to the highest vector */
#define LDT_SIZE         2	/* contains CS and DS only */

/* Fixed global descriptors.  1 to 7 are prescribed by the monitor. */
#define GDT_INDEX        1	/* GDT descriptor */
#define IDT_INDEX        2	/* IDT descriptor */
#define DS_INDEX         3	/* kernel DS */
#define ES_INDEX         4	/* kernel ES at startup */
#define SS_INDEX         5	/* kernel SS at startup = monitor SS */
#define CS_INDEX         6	/* kernel CS */
#define MON_CS_INDEX     7	/* monitor CS */
#define TSS_INDEX        8	/* kernel TSS */
#define VIDEO_INDEX      9	/* video memory segment */
#define DP_ETH0_INDEX	10	/* Western Digital Etherplus buffer */
#define DP_ETH1_INDEX	11	/* Western Digital Etherplus buffer */
#define FIRST_LDT_INDEX 12	/* rest of descriptors are LDT's */

#define GDT_SELECTOR      0x08	/* (GDT_INDEX * DESC_SIZE) bad for asld */
#define IDT_SELECTOR      0x10	/* (IDT_INDEX * DESC_SIZE) */
#define DS_SELECTOR       0x18	/* (DS_INDEX * DESC_SIZE) */
#define ES_SELECTOR       0x20	/* (ES_INDEX * DESC_SIZE) */
#define FLAT_DS_SELECTOR  0x21	/* less privileged ES */
#define SS_SELECTOR       0x28	/* (SS_INDEX * DESC_SIZE) */
#define CS_SELECTOR       0x30	/* (CS_INDEX * DESC_SIZE) */
#define MON_CS_SELECTOR   0x38	/* (MON_CS_INDEX * DESC_SIZE) */
#define TSS_SELECTOR      0x40	/* (TSS_INDEX * DESC_SIZE) */
#define VIDEO_SELECTOR    0x49	/* (VIDEO_INDEX * DESC_SIZE + 1) */
#define DP_ETH0_SELECTOR  0x51	/* (DP_ETH0_INDEX * DESC_SIZE + 1) */
#define DP_ETH1_SELECTOR  0x59	/* (DP_ETH1_INDEX * DESC_SIZE + 1) */

/* Fixed local descriptors. */
#define CS_LDT_INDEX     0	/* process CS */
#define DS_LDT_INDEX     1	/* process DS=ES=FS=GS=SS */

/* Privileges. */
#define INTR_PRIVILEGE   0	/* kernel and interrupt handlers */
#define TASK_PRIVILEGE   1
#define USER_PRIVILEGE   3

/* 286 hardware constants. */

/* Exception vector numbers. */
#define BOUNDS_VECTOR       5	/* bounds check failed */
#define INVAL_OP_VECTOR     6	/* invalid opcode */
#define COPROC_NOT_VECTOR   7	/* coprocessor not available */
#define DOUBLE_FAULT_VECTOR 8
#define COPROC_SEG_VECTOR   9	/* coprocessor segment overrun */
#define INVAL_TSS_VECTOR   10	/* invalid TSS */
#define SEG_NOT_VECTOR     11	/* segment not present */
#define STACK_FAULT_VECTOR 12	/* stack exception */
#define PROTECTION_VECTOR  13	/* general protection */

/* Selector bits. */
#define TI            0x04	/* table indicator */
#define RPL           0x03	/* requester privilege level */

/* Descriptor structure offsets. */
#define DESC_BASE        2	/* to base_low */
#define DESC_BASE_MIDDLE 4	/* to base_middle */
#define DESC_ACCESS      5	/* to access byte */
#define DESC_SIZE        8	/* sizeof (struct segdesc_s) */

/* Segment sizes. */
#define MAX_286_SEG_SIZE 0x10000L

/* Base and limit sizes and shifts. */
#define BASE_MIDDLE_SHIFT   16	/* shift for base --> base_middle */

/* Access-byte and type-byte bits. */
#define PRESENT       0x80	/* set for descriptor present */
#define DPL           0x60	/* descriptor privilege level mask */
#define DPL_SHIFT        5
#define SEGMENT       0x10	/* set for segment-type descriptors */

/* Access-byte bits. */
#define EXECUTABLE    0x08	/* set for executable segment */
#define CONFORMING    0x04	/* set for conforming segment if executable */
#define EXPAND_DOWN   0x04	/* set for expand-down segment if !executable*/
#define READABLE      0x02	/* set for readable segment if executable */
#define WRITEABLE     0x02	/* set for writeable segment if !executable */
#define TSS_BUSY      0x02	/* set if TSS descriptor is busy */
#define ACCESSED      0x01	/* set if segment accessed */

/* Special descriptor types. */
#define AVL_286_TSS      1	/* available 286 TSS */
#define LDT              2	/* local descriptor table */
#define BUSY_286_TSS     3	/* set transparently to the software */
#define CALL_286_GATE    4	/* not used */
#define TASK_GATE        5	/* only used by debugger */
#define INT_286_GATE     6	/* interrupt gate, used for all vectors */
#define TRAP_286_GATE    7	/* not used */

/* MSW bits. */
#define MSW_TS      0x0008	/* set with MSW_MP to enable trap on wait */
#define MSW_EM      0x0004	/* set to enable trap on any FP instruction */
#define MSW_MP      0x0002	/* set with MSW_TS to enable trap on wait */
#define MSW_PE      0x0001	/* protection enable */

/* Extra 386 hardware constants. */

/* Exception vector numbers. */
#define PAGE_FAULT_VECTOR   14
#define FP_ERR_VECTOR       16	/* floating point error (use 486 name) */

/* Descriptor structure offsets. */
#define DESC_GRANULARITY     6	/* to granularity byte */
#define DESC_BASE_HIGH       7	/* to base_high */

/* Base and limit sizes and shifts. */
#define BASE_HIGH_SHIFT     24	/* shift for base --> base_high */
#define BYTE_GRAN_MAX   0xFFFFFL   /* maximum size for byte granular segment */
#define GRANULARITY_SHIFT   16	/* shift for limit --> granularity */
#define OFFSET_HIGH_SHIFT   16	/* shift for (gate) offset --> offset_high */
#define PAGE_GRAN_SHIFT     12	/* extra shift for page granular limits */

/* Type-byte bits. */
#define DESC_386_BIT      0x08	/* 386 types are obtained by ORing with this */
				/* LDT's and TASK_GATE's don't need it */

/* CR0 bits. */
#define CR0_PG	0x80000000	/* enable paging */
#define CR0_TS	    MSW_TS	
#define CR0_EM	    MSW_EM	
#define CR0_MP	    MSW_MP	
#define CR0_PE	    MSW_PE	

/* Granularity byte. */
#define GRANULAR          0x80	/* set for 4K granularilty */
#define DEFAULT           0x40	/* set for 32-bit defaults (executable seg) */
#define BIG               0x40	/* set for "BIG" (expand-down seg) */
#define AVL               0x10	/* 0 for available */
#define LIMIT_HIGH        0x0F	/* mask for high bits of limit */

/* Extra 486 hardware constants. */

/* Exception vector numbers. */
#define ALIGNMENT_VECTOR    17	/* alignment check failed */

/* Eflags bits. */
#define EF_AC       0x00040000	/* alignment check enable (if AM in CR0) */

/* CR0 bits. */
#define CR0_CD	    0x40000000	/* disable caching on a 486 */
#define CR0_NW	    0x20000000	/* not write-through on a 486 */
#define CR0_AM      0x00040000	/* alignment check enable (if AC in flags) */
#define CR0_WP	    0x00010000	/* write protect user pages */
#define CR0_NE      0x00000020	/* FP numeric error enable */

/*
 * $PchId: protect.h,v 1.4 1995/12/22 09:40:47 philip Exp $
 */
