#
! i387.ack.s
!
! Implement support functions to save, restore and initialize the fpu
!
! Created:	Dec 15, 1992 by Philip Homburg

.sect .text; .sect .rom; .sect .data; .sect .bss

#include <minix/cfg_public.h>
#include "protect.h"
#include "sconst.h"

/* Functions defined here */
.define _fpu_save
.define _fpu_store
.define _fpu_empty
.define _fpu_reload
.define _fpu_probe
.define _fpu_fdiv_test

/* Imported variables */
.extern _fpu_proc_ptr

.sect .text
_fpu_save:
	clts				! We plan to use the fpu no matter what
	wait				! Wait for exceptions
	mov	eax, (_fpu_proc_ptr)	! Get the user of the fpu
	test	eax, eax
	jz	L0			! No user
	fsave	P_FP_STATE(eax)		! Save fpu context
	wait				! Wait for the save to complete
	mov	edx, MSW_TS		! TS bit
	or	P_MSW(eax), edx		! Set TS bit to mark task as not using 
					! the fpu
	xor	eax, eax
	mov	(_fpu_proc_ptr), eax	! no current fpu user
L0:
	ret

_fpu_store:
	mov	eax, (_fpu_proc_ptr)	! Get the user of the fpu
	fsave	P_FP_STATE(eax)
	wait				! Wait for the save to complete
	ret

_fpu_empty:
	finit
	ret

_fpu_reload:
	mov	eax, (_fpu_proc_ptr)
	frstor	P_FP_STATE(eax)
	ret

_fpu_probe:
	mov	eax, ~0
	finit
	fstsw	ax
o16	test	ax, ax
	setz	al		! true if present
	movzxb	eax, al
	ret

_fpu_fdiv_test:			! test division instruction
	fldd	(numerator)
	fdivd	(denominator)
	fmuld	(denominator)
	fsubrd	(numerator)
	fld1
	fcompp
	fstsw	ax
	sahf
	seta	al		! al = ((n - (n / d) * d) < 1.0);
	movzxb	eax, al
	ret

.sect .rom
numerator:
	.data1	0x00, 0x00, 0x00, 0xC0, 0x7E, 0x01, 0x50, 0x41	! 4195835.0
denominator:
	.data1	0x00, 0x00, 0x00, 0x80, 0xFF, 0xFF, 0x47, 0x41	! 3145727.0

!
! $PchId: i387.ack.s,v 1.5 1995/12/22 09:48:28 philip Exp $
!
