/* Global variables used in the kernel. */

/* EXTERN is defined as extern except in table.c. */
#ifdef _TABLE
#undef EXTERN
#define EXTERN
#endif

/* Kernel memory. */
EXTERN phys_bytes kernel_code_base;	/* base of kernel code */
EXTERN phys_bytes kernel_data_base;	/* base of kernel data */
EXTERN char k_environ[512];	/* environment strings passed by loader */

/* Low level interrupt communications. */
EXTERN struct proc *held_list;	/* head of list of held-up interrupts */
EXTERN signed char k_reenter;	/* kernel reentry count (entry count less 1)*/

/* Process table.  Here to stop too many things having to include proc.h. */
EXTERN struct proc *proc_ptr;	/* pointer to currently running process */

/* Signals. */
EXTERN struct proc *sig_proclist;	/* list of procs with sigs pending. */

/* Miscellaneous. */
extern struct coretab coretab[];/* initialized in table.c, so extern here */
extern struct tasktab tasktab[];/* initialized in table.c, so extern here */
extern char *t_stack[];		/* initialized in table.c, so extern here */
extern int clck_tasknr;		/* initialized to ANY in table.c */
EXTERN unsigned lost_ticks;	/* clock ticks counted outside the clock task */
EXTERN int debug;		/* debug mode */

/* Memory. */
EXTERN chunk_t chunk_table[CHUNK_NR];

#if LOADAV
EXTERN unsigned long loadav[LDAV_NR];	/* load avarage array */
#endif /* LOADAV */

#if (CHIP == INTEL)

/* Machine type. */
#define pc_at	1		/* PC-AT compatible hardware interface */
EXTERN int ps_mca;		/* PS/2 with Micro Channel */
EXTERN unsigned processor;	/* 86, 186, 286, 386, ... */
#define protected_mode	1	/* 386 mode implies protected mode */

/* Video card types and keyboard flags. */
EXTERN int ega;			/* nonzero if console is EGA */
EXTERN int vga;			/* nonzero if console is VGA */
EXTERN int kbd_int_pending;
EXTERN int disable_cons_output;
EXTERN int log_cons_output;

#if PROFILING
EXTERN int profile_int_pending;
EXTERN struct proc *profile_proc;
EXTERN reg_t profile_pc;
EXTERN reg_t profile_bp;
#endif /* PROFILING */

#if _PKG_LOG
EXTERN int log_int_pending;
#endif /* _PKG_LOG */

#if _PKG_RAWKBD
EXTERN int rawkbd_int_pending;
EXTERN int rawkbd_enabled;
#endif /* _PKG_RAWKBD */

/* Memory sizes. */
EXTERN unsigned ext_memsize;	/* initialized by assembler startup code */
EXTERN unsigned low_memsize;


/* Miscellaneous. */
EXTERN irq_handler_t irq_table[NR_IRQ_VECTORS];
EXTERN int irq_use;		/* bit map of all in-use irq's */
EXTERN struct irq_ent irq_admin[NR_IRQ_VECTORS];
EXTERN u16_t mon_ss, mon_sp;	/* monitor stack */
EXTERN int mon_return;		/* true if return to the monitor possible */
EXTERN phys_bytes reboot_code;	/* program for the boot monitor */
EXTERN union reg86 reg86;	/* registers used in an 8086 interrupt */

/* Variables that are initialized elsewhere are just extern here. */
extern struct segdesc_s gdt[];	/* global descriptor table for protected mode*/

#if VIRT_MEM
EXTERN reg_t cpmess_stackptr;	/* Special treatment of pagefault while
				 * copying a message if not null.
				 * The stackpoint is used to locate the
				 * program counter.
				 */
EXTERN u32_t cpmess_faultaddr;	/* virtual address that prevents the
				 * message from being copied.
				 */
EXTERN int vm_not_alloc;	/* Not allocated (reserved) real memory */
EXTERN int vm_lowest_free;	/* Minimum vm_not_alloc (informational) */
#endif /* VIRT_MEM */

EXTERN _PROTOTYPE( void (*level0_func), (void) );
#endif /* (CHIP == INTEL) */

#if (CHIP == M68000)
/* Variables that are initialized elsewhere are just extern here. */
extern int keypad;		/* Flag for keypad mode */
extern int app_mode;		/* Flag for arrow key application mode */
extern int STdebKey;		/* nonzero if ctl-alt-Fx detected */
extern struct tty_struct *cur_cons; /* virtual cons currently displayed */
extern unsigned char font8[];	/* 8 pixel wide font table (initialized) */
extern unsigned char font12[];	/* 12 pixel wide font table (initialized) */
extern unsigned char font16[];	/* 16 pixel wide font table (initialized) */
#endif

/*
 * $PchId: glo.h,v 1.5 1996/01/19 23:27:01 philip Exp $
 */
