/* Types and constants shared between the generic and device dependent
 * device driver code.
 */

#include <minix/callnr.h>
#include <minix/com.h>
#include "config.h"
#include "proc.h"
#include "timer.h"
#include <minix/partition.h>
#if (CHIP == INTEL) && VIRT_MEM
#include "i386/vm386.h"
#endif

/* Info about and entry points into the device dependent code. */
struct driver {
  _PROTOTYPE( char *(*dr_name), (void) );
  _PROTOTYPE( int (*dr_open), (struct driver *dp, message *m_ptr) );
  _PROTOTYPE( int (*dr_close), (struct driver *dp, message *m_ptr) );
  _PROTOTYPE( int (*dr_ioctl), (struct driver *dp, message *m_ptr) );
  _PROTOTYPE( struct device *(*dr_prepare), (int device) );
  _PROTOTYPE( int (*dr_transfer), (int proc_nr, int opcode, u64_t position,
					iovec_t *iov, unsigned nr_req) );
  _PROTOTYPE( void (*dr_cleanup), (void) );
  _PROTOTYPE( void (*dr_geometry), (struct partition *entry) );
  tmrs_context_ut dr_tmrs_context;
};

#if (CHIP == INTEL)

/* Some tasks have different identities. */
#define ENABLE_WINI	(ENABLE_AT_WINI || ENABLE_BIOS_WINI || ENABLE_ESDI_WINI)
#define ENABLE_SCSI	(ENABLE_ADAPTEC_SCSI)
#define ENABLE_CDROM	(ENABLE_MITSUMI_CDROM)
#define ENABLE_AUDIO	(ENABLE_SB_AUDIO)

/* Number of bytes you can DMA before hitting a 64K boundary: */
#define dma_bytes_left(phys)    \
   ((unsigned) (sizeof(int) == 2 ? 0 : 0x10000) - (unsigned) ((phys) & 0xFFFF))

/* Virtual memory complicates the memory model of the machine somewhat, now
 * you have virtual addresses for processes, physical addresses for the kernel
 * to see all processes, and bus adresses that appear on the memory bus.
 * Without virtual memory the latter two addresses are the same, with virtual
 * memory this is only true for the kernel.  For processes you have to look
 * through the pages translation for the bus address.  For DMA you need bus
 * addresses and you have to stop at a page boundary.
 */
#define phys2bus(phys)		vm_1phys2bus(phys)
#define page_bytes_left(phys)	(VM_PAGESIZE - ((phys) & VM_PAGEMASK))

#endif /* CHIP == INTEL */

/* Base and size of a partition in bytes. */
struct device {
  u64_t dv_base;
  u64_t dv_size;
};

#define NIL_DEV		((struct device *) 0)

/* Functions defined by driver.c: */
_PROTOTYPE( void driver_task, (struct driver *dr) );
_PROTOTYPE( int do_rdwt, (struct driver *dr, message *m_ptr) );
_PROTOTYPE( int do_vrdwt, (struct driver *dr, message *m_ptr) );
_PROTOTYPE( char *no_name, (void) );
_PROTOTYPE( int do_nop, (struct driver *dp, message *m_ptr) );
_PROTOTYPE( void nop_cleanup, (void) );
_PROTOTYPE( int do_diocntl, (struct driver *dr, message *m_ptr) );

/* Parameters for the disk drive. */
#define SECTOR_SIZE      512	/* physical sector size in bytes */
#define SECTOR_SHIFT       9	/* for division */
#define SECTOR_MASK      511	/* and remainder */

/* Size of the DMA buffer buffer in bytes. */
#define DMA_BUF_SIZE	(DMA_SECTORS * SECTOR_SIZE)

#if (CHIP == INTEL)
extern u8_t *tmp_buf;			/* the DMA buffer */
#else
extern u8_t tmp_buf[];			/* the DMA buffer */
#endif
extern phys_bytes tmp_phys;		/* phys address of DMA buffer */


/*
 * $PchId: driver.h,v 1.4 1995/12/22 09:51:35 philip Exp $
 */
