/*
type.h
*/

/* Avoid too many changes to exiting code. */
typedef zone2_t zone_t;

/* Declaration of the V1 inode as it is on the disk (not in core). */
typedef struct {		/* V1.x disk inode */
  mode_t d1_mode;		/* file type, protection, etc. */
  uid_t d1_uid;			/* user id of the file's owner */
  uoff_t d1_size;		/* current file size in bytes */
  time_t d1_mtime;		/* when was file data last changed */
  u8_t d1_gid;			/* group number */
  u8_t d1_nlinks;		/* how many links to this file */
  u16_t d1_zone[V1_NR_TZONES];	/* block nums for direct, ind, and dbl ind */
} d1_inode;

/* Declaration of the V2 inode as it is on the disk (not in core). */
typedef struct {		/* V2.x disk inode */
  mode_t d2_mode;		/* file type, protection, etc. */
  nlink_t d2_nlinks;		/* how many links to this file. */
  uid_t d2_uid;			/* user id of the file's owner. */
  gid_t d2_gid;			/* group number */
  uoff_t d2_size;		/* current file size in bytes */
  time_t d2_atime;		/* when was file data last accessed */
  time_t d2_mtime;		/* when was file data last changed */
  time_t d2_ctime;		/* when was inode data last changed */
  zone_t d2_zone[V2_NR_TZONES];	/* block nums for direct, ind, and dbl ind */
} d2_inode;

/*
 * $PchId: type.h,v 1.5 1995/11/28 07:29:40 philip Exp $
 */
