/* This file contains the table used to map system call numbers onto the
 * routines that perform them.
 */

#define _TABLE

#include "fs.h"
#include <minix/callnr.h>
#include <minix/com.h>
#include "buf.h"
#include "dev.h"
#include "file.h"
#include "fproc.h"
#include "inode.h"
#include "lock.h"
#include "name.h"
#include "super.h"

PUBLIC int clck_tasknr= ANY;
PUBLIC struct super_block *pipe_fs= &super_block[0];	/* root fs */

/* <minix/scalltab.h>  is not just a header file, but the definition and
 * initialization of the system call table.
 */
#define FS_SCALL_TABLE	1
#include <minix/scalltab.h>

int asio_ip[ASIO_NR]= { ODF_RD_IP, ODF_WR_IP, ODF_IOC_IP };
					/* convert ASIO_xx to ODF_xx_IP */
int asio_compl[ASIO_NR]= { ODF_RD_COMPL, ODF_WR_COMPL, ODF_IOC_COMPL };
					/* convert ASIO_xx to ODF_xx_COMPL */
int asio_cancel[ASIO_NR]= { DEV_READ, DEV_WRITE, DEV_IOCTL3 };
					/* convert ASIO_xx to CANCEL_xx */
int asio_event[ASIO_NR]= { EV_READ, EV_WRITE, EV_IOCTL };
					/* convert ASIO_xx to EV_xx */

PUBLIC struct dmap dmap_table[NR_DMAPS] = {
/*
   File		    Open	 Close	     Read/Write	   Ioctl
   ----		    ----	 -----	     ----------	   -----
		    Cancel	 Message     Task #	   Device
		    ------	 -------     ------	   ------  */
/* /dev/mem */    { gen_opcl,    gen_opcl,   gen_rw,       gen_ioctl,
		    no_cancel,   gen_msg,    ANY,          1,
		    MEM_NAME,						},
/* /dev/fd */     { gen_opcl,    gen_opcl,   gen_rw,       gen_ioctl,
		    no_cancel,   gen_msg,    ANY,          2,
		    FLOPPY_NAME,					},
/* /dev/hd */     { gen_opcl,    gen_opcl,   gen_rw,       gen_ioctl,
		    no_cancel,   gen_msg,    ANY,          3,
		    WINCHE_NAME,					},
/* /dev/console */{ ntty_open,   ntty_close, ngen_rw,      ngen_ioctl,
		    ngen_cancel, gen_msg,    ANY,	   4,
		    CONS_NAME,						},
/* /dev/tty */    { ctty_open,   ctty_close, ctty_rw,      ctty_ioctl,
		    ctty_cancel, ctty_msg,   ANY,          CTTY_MAJOR,
		    NULL,						},
/* /dev/lp */     { gen_opcl,    gen_opcl,   ogen_rw,      no_ioctl,
		    gen_cancel,  gen_msg,    ANY,          6,
		    PRINTER_NAME,					},
/* /dev/cd */     { gen_opcl,    gen_opcl,   gen_rw,       gen_ioctl,
		    no_cancel,   gen_msg,    ANY,	   8,
		    CDROM_NAME,					        },
/* /dev/ptyXX */  { ntty_open,   ntty_close, ngen_rw,      ngen_ioctl,
		    ngen_cancel, gen_msg,    ANY,          9,
		    PTY_NAME,						},
/* /dev/s[td] */  { gen_opcl,    gen_opcl,   gen_rw,       gen_ioctl,
		    no_cancel,   gen_msg,    ANY,	   10,
		    SCSI0_NAME,					        },
/* /dev/tty00 */  { ntty_open,   ntty_close, ngen_rw,      ngen_ioctl,
		    ngen_cancel, gen_msg,    ANY,	   11,
		    SERIAL_NAME,				        },
/* /dev/dosd */   { gen_opcl,    gen_opcl,   gen_rw,       gen_ioctl,
		    no_cancel,   gen_msg,    ANY,	   12,
		    DOSDSK_NAME,				        },
/* /dev/audio */  { gen_opcl,    gen_opcl,   gen_rw,       gen_ioctl,
		    no_cancel,   gen_msg,    ANY,	   13,
		    AUDIO_NAME,					        },
/* /dev/mixer */  { gen_opcl,    gen_opcl,   gen_rw,       gen_ioctl,
		    no_cancel,   gen_msg,    ANY,	   14,
		    MIXER_NAME,					        },
/* /dev/vd */     { gen_opcl,    gen_opcl,   gen_rw,       gen_ioctl,
		    no_cancel,   gen_msg,    ANY,	   15,
		    VDISK_NAME,				        	},

	/* More space here for dynamic devices. */
};

/*
 * $PchId: table.c,v 1.6 1995/11/28 07:30:43 philip Exp $
 */
