/* Function prototypes. */

/* Structs used in prototypes must be declared as such first. */
struct buf;
struct od;
struct filp;		
struct inode;
struct super_block;
struct mount;
struct fproc;

/* cache.c */
_PROTOTYPE( zone_t alloc_zone, (Dev_t dev, zone_t z, int *err_p)	);
_PROTOTYPE( void flushall, (Dev_t dev)					);
_PROTOTYPE( void free_zone, (Dev_t dev, zone_t numb)			);
_PROTOTYPE( struct buf *get_block, (Dev_t dev,
			block_t block, int only_search)			);
_PROTOTYPE( void invalidate, (Dev_t device)				);
_PROTOTYPE( void put_block, (struct buf *bp)				);
_PROTOTYPE( struct buf *buf_vrfy_ptr, (struct buf *ptr, Dev_t dev,
							block_t block)	);
_PROTOTYPE( void rw_scattered, (struct buf *bufq, int rw_flag)		);
_PROTOTYPE( void buf_pool, (void)					);
_PROTOTYPE( void sync_all_bufs, (int dirt_level)			);

/* compat.c */
_PROTOTYPE( int do_cpt_rename, (void)					);
_PROTOTYPE( int do_cpt_mkdir, (void)					);
_PROTOTYPE( int do_cpt_rmdir, (void)					);
_PROTOTYPE( int do_cpt_fcntl, (void)					);

/* device.c */
_PROTOTYPE( void call_task, (int task_nr, message *mess_ptr)		);
_PROTOTYPE( void call_ntask, (int task_nr, message *mess_ptr)		);
_PROTOTYPE( void dev_init, (void)					);
_PROTOTYPE( int dev_opcl, (int open_close, Dev_t device, int user_task,
				int flags)		);
_PROTOTYPE( int dev_cancel, (int what, Dev_t device, int user_task, 
				int ref)				);
_PROTOTYPE( int dev_rw, (int op, Dev_t device, int user_task, u64_t pos,
			char *buf, unsigned bytes, int ref, int flags)	);
_PROTOTYPE( int dev_ioctl, (Dev_t device, int user_task,
		ioreq_t function, char *buf, int ref, int flags)	);
_PROTOTYPE( int dev_msg, (Dev_t device, int user_task, message *m_ptr)	);
_PROTOTYPE( int do_ioctl, (void)					);
_PROTOTYPE( int do_ioctl3, (void)					);
_PROTOTYPE( int gen_opcl, (int open_close, Dev_t device, int dev_task, 
					int user_task, int flags)	);
_PROTOTYPE( int gen_rw, (int op, Dev_t device, int dev_task,
				int user_task, u64_t pos, char *buf, 
				unsigned bytes, int ref, int flags)	);
_PROTOTYPE( int gen_ioctl, (Dev_t device, int dev_task, int user_task,
		ioreq_t function, char *buf, int ref, int flags)	);
_PROTOTYPE( int gen_cancel, (int operation, Dev_t device, int dev_task,
						int user_task, int ref)	);
_PROTOTYPE( int gen_msg, (Dev_t device, int dev_task, int user_task,
							message *m_ptr)	);
_PROTOTYPE( int ngen_opcl, (int open_close, Dev_t device, int dev_task, 
					int user_task, int flags)	);
_PROTOTYPE( int ngen_rw, (int op, Dev_t device, int dev_task,
				int user_task, u64_t pos, char *buf, 
				unsigned bytes, int ref, int flags)	);
_PROTOTYPE( int ngen_ioctl, (Dev_t device, int dev_task, int user_task,
		ioreq_t function, char *buf, int ref, int flags)	);
_PROTOTYPE( int ngen_cancel, (int operation, Dev_t device, int dev_task,
						int user_task, int ref)	);
_PROTOTYPE( int ogen_rw, (int op, Dev_t device, int dev_task,
				int user_task, u64_t pos, char *buf, 
				unsigned bytes, int ref, int flags)	);
_PROTOTYPE( int clone_open, (int open_close, Dev_t device, int dev_task, 
					int user_task, int flags)	);
_PROTOTYPE( int no_opcl, (int open_close, Dev_t device, int dev_task,
					int user_task, int open_flags)	);
_PROTOTYPE( int no_ioctl, (Dev_t device, int dev_task, int user_task,
		ioreq_t function, char *buf, int ref, int flags)	);
_PROTOTYPE( int no_cancel, (int operation, Dev_t device, int dev_task,
						int user_task, int ref)	);
_PROTOTYPE( int no_msg, (Dev_t device, int dev_task, int user_task,
							message *m_ptr)	);

/* filedes.c */
_PROTOTYPE( struct filp *find_filp, (struct inode *rip, Mode_t bits)	);
_PROTOTYPE( int new_fd, (int start, Mode_t bits, int *k, 
						struct od **fpt)	);
_PROTOTYPE( struct od *get_fd, (int fild, int *err_p)			);
_PROTOTYPE( void fd_suspend, (int event, int fd)			);
_PROTOTYPE( void fd_revive, (int task, int fd, int operation, int result));
_PROTOTYPE( int fd_cancel, (int task, int fd, int operation)		);
_PROTOTYPE( int do_nrevive, (void)					);
_PROTOTYPE( struct filp *get_filp, (int fild, int *err_p)		);
#if PCH_DEBUG
_PROTOTYPE( int check_filedes, (void)					);
#endif
_PROTOTYPE( void cancel_fdops, (struct fproc *fp, int fd_nr)		);

/* inode.c */
_PROTOTYPE( struct inode *alloc_inode, (struct super_block *sp,
					Mode_t bits, int *err_p)	);
_PROTOTYPE( void dup_inode, (struct inode *ip)				);
_PROTOTYPE( void free_inode, (struct inode *ip)				);
_PROTOTYPE( struct inode *get_inode, (Dev_t dev, int numb, int *err_p)	);
_PROTOTYPE( void put_inode, (struct inode *rip)				);
_PROTOTYPE( struct inode *inode_vrfy_ptr, (struct inode *ptr,
						Dev_t dev, Ino_t ino)	);
_PROTOTYPE( void update_times, (struct inode *rip)			);
_PROTOTYPE( void rw_inode, (struct inode *rip, int rw_flag)		);
_PROTOTYPE( void flushall_inodes, (Dev_t dev)				);
_PROTOTYPE( void invalidate_inodes, (Dev_t dev)				);
_PROTOTYPE( int check_ihash, (void)					);


/* link.c */
_PROTOTYPE( int do_link, (void)						);
_PROTOTYPE( int do_unlink, (void)					);
_PROTOTYPE( int do_rename, (void)					);
_PROTOTYPE( void freespace, (struct inode *rip, uoff_t offset, uoff_t limit) );

/* lock.c */
_PROTOTYPE( int lock_op, (struct filp *f, int req, char *arg)		);
_PROTOTYPE( void lock_init, (void)					);
_PROTOTYPE( void lock_revive, (void)					);
_PROTOTYPE( void lock_unlock, (struct filp *filp)			);

/* main.c */
_PROTOTYPE( void main, (void)						);
_PROTOTYPE( void reply, (int whom, int result)				);

/* misc.c */
_PROTOTYPE( int do_dup, (void)						);
_PROTOTYPE( int do_exit, (void)						);
_PROTOTYPE( int do_fcntl, (void)					);
_PROTOTYPE( int do_fork, (void)						);
_PROTOTYPE( int do_exec, (void)						);
_PROTOTYPE( int do_revive, (void)					);
_PROTOTYPE( int do_set, (void)						);
_PROTOTYPE( int do_sysuname, (void)					);
_PROTOTYPE( int do_sync, (void)						);
_PROTOTYPE( int do_reboot, (void)					);
_PROTOTYPE( void sync_all, (int dirt_level)				);
_PROTOTYPE( int do_fcancel, (void)					);
_PROTOTYPE( int do_fwait, (void)					);
_PROTOTYPE( int do_unpause, (void)					);
_PROTOTYPE( int do_svrctl, (void)					);

/* mount.c */
_PROTOTYPE( int do_mount, (void)					);
_PROTOTYPE( int do_umount, (void)					);
_PROTOTYPE( int unmount, (struct mount *mp)				);

/* open.c */
_PROTOTYPE( int do_close, (void)					);
_PROTOTYPE( int do_creat, (void)					);
_PROTOTYPE( int do_lseek, (void)					);
_PROTOTYPE( int do_mknod, (void)					);
_PROTOTYPE( int do_mkdir, (void)					);
_PROTOTYPE( int do_open, (void)						);
_PROTOTYPE( int closefd, (int pfd)					);
#if VMDEXT_SYMLINK
_PROTOTYPE( int do_slink, (void)					);
#endif /* VMDEXT_SYMLINK */

/* path.c */
_PROTOTYPE( struct inode *advance,
	(struct inode **pdirp, char string [NAME_MAX], int *err_p)	);
_PROTOTYPE( int search_dir, (struct inode *ldir_ptr,
			char string [NAME_MAX], ino_t *numb, int flag)	);
_PROTOTYPE( struct inode *eat_path, (char *path, int *err_p)		);
_PROTOTYPE( struct inode *last_dir, (char *path, char string [NAME_MAX],
							int *err_p)	);
#if VMDEXT_SYMLINK
_PROTOTYPE( struct inode *parse_path, (char *path, char string[NAME_MAX], 
						int action, int *err_p)	);
#endif /* VMDEXT_SYMLINK */

/* pipe.c */
_PROTOTYPE( int do_pipe, (void)						);
/* _PROTOTYPE( int pipe_rdwr, (void)					); */

_PROTOTYPE( int pipe_check, (struct inode *rip, int rw_flag,
			int oflags, int bytes, uoff_t position, int *canwrite));
_PROTOTYPE( void release, (struct inode *ip, int call_nr, int count)	);
_PROTOTYPE( void revive, (int proc_nr, int bytes)			);
_PROTOTYPE( void suspend, (int event)					);

/* protect.c */
_PROTOTYPE( int do_access, (void)					);
_PROTOTYPE( int do_chmod, (void)					);
_PROTOTYPE( int do_chown, (void)					);
_PROTOTYPE( int do_umask, (void)					);
_PROTOTYPE( int forbidden, (struct inode *rip, Mode_t access_desired)	);
_PROTOTYPE( int read_only, (struct inode *ip)				);
_PROTOTYPE( int group_member, (Gid_t gid)				);

/* putk.c */
_PROTOTYPE( void putk, (int c)						);

/* read.c */
_PROTOTYPE( int do_read, (void)						);
_PROTOTYPE( void read_ahead, (void)					);
_PROTOTYPE( block_t read_map, (struct inode *rip, uoff_t position)	);
_PROTOTYPE( int read_write, (int rw_flag, int fd, char *buffer,
						unsigned nbytes)	);
_PROTOTYPE( zone_t rd_indir, (struct buf *bp, int index)		);
_PROTOTYPE( int rw_chunk, (struct inode *rip, u64_t position,
	unsigned off, int chunk, unsigned left, int rw_flag, char *buff, 
	int seg, int usr)						);

/* stadir.c */
_PROTOTYPE( int do_chdir, (void)					);
_PROTOTYPE( int do_chroot, (void)					);
_PROTOTYPE( int do_fstat, (void)					);
_PROTOTYPE( int do_stat, (void)						);
#if VMDEXT_SYMLINK
_PROTOTYPE( int do_rdlink, (void)					);
_PROTOTYPE( int do_lstat, (void)					);
#endif /* VMDEXT_SYMLINK */

/* super.c */
_PROTOTYPE( bit_t alloc_bit, (struct super_block *sp, int map,
							bit_t origin)	);
_PROTOTYPE( void free_bit, (struct super_block *sp, int map,
						bit_t bit_returned)	);
_PROTOTYPE( struct super_block *search_super, (Dev_t dev)		);
_PROTOTYPE( struct super_block *get_super, (Dev_t dev)			);
_PROTOTYPE( int load_bit_maps, (Dev_t dev)				);
_PROTOTYPE( void do_super_clean, (struct super_block *sp, int clean)	);
_PROTOTYPE( void read_super, (struct super_block *sp)			);
_PROTOTYPE( int unload_bit_maps, (Dev_t dev)				);

/* time.c */
_PROTOTYPE( int do_stime, (void)					);
_PROTOTYPE( int do_time, (void)						);
_PROTOTYPE( int do_tims, (void)						);
_PROTOTYPE( int do_utime, (void)					);
_PROTOTYPE( int do_sysutime, (void)					);

/* tty.c */
_PROTOTYPE( int do_setsid, (void)					);
_PROTOTYPE( void exit_sesldr, (void)					);
_PROTOTYPE( int ctty_open, (int open_close, Dev_t device, int dev_task, 
					int user_task, int flags)	);
_PROTOTYPE( int ctty_close, (int open_close, Dev_t device, int dev_task, 
					int user_task, int flags)	);
_PROTOTYPE( int ctty_rw, (int op, Dev_t device, int dev_task,
				int user_task, u64_t pos, char *buf,
				unsigned bytes, int ref, int flags)	);
_PROTOTYPE( int ctty_ioctl, (Dev_t device, int dev_task, int user_task,
		ioreq_t function, char *buf, int ref, int flags)	);
_PROTOTYPE( int ctty_cancel, (int operation, Dev_t device, int dev_task,
						int user_task, int ref)	);
_PROTOTYPE( int ctty_msg, (Dev_t device, int dev_task, int user_task,
							message *m_ptr)	);
_PROTOTYPE( int ntty_open, (int open_close, Dev_t device, int dev_task, 
					int user_task, int flags)	);
_PROTOTYPE( void ntty_rw, (int task_nr, message *mess_ptr)		);
_PROTOTYPE( int ntty_close, (int open_close, Dev_t device, int dev_task, 
					int user_task, int flags)	);

/* utility.c */
_PROTOTYPE( time_t clock_time, (void)					);
_PROTOTYPE( unsigned swap2, (int w)					);
_PROTOTYPE( long swap4, (long l)					);
_PROTOTYPE( int fetch_name, (char *path, int len, int flag)		);
_PROTOTYPE( int no_sys, (void)						);
_PROTOTYPE( void panic, (char *format, int num)				);
_PROTOTYPE( int clock_utime, (int _proc, int _op, void *_ptr)		);
#if (CHIP == INTEL && WORD_SIZE == 4)
_PROTOTYPE( void stacktrace, (void)					);
#endif /* CHIP == INTEL  && WORD_SIZE == 4 */


/* write.c */
_PROTOTYPE( void clear_zone, (struct inode *rip, uoff_t pos, int flag)	);
_PROTOTYPE( int do_write, (void)					);
_PROTOTYPE( int write_map, (struct inode *rip, uoff_t position,
						zone_t new_zone)	);
_PROTOTYPE( struct buf *new_block, (struct inode *rip, uoff_t position, 
						int zero, int *err_p)	);

/*
 * $PchId: proto.h,v 1.8 1996/01/19 23:11:26 philip Exp $
 */
