/*
name.h

Declarations for the name cache.

Created:	February 1995 by Philip Homburg <philip@cs.vu.nl>
*/

#define NR_NAMES	256
#define NR_NAMES_HASH	256
#define NAME_SIZE	 16

#if 0
#undef NR_NAMES
#define NR_NAMES	10
#endif

EXTERN struct name
{
	struct name *n_next;		/* Next entry in the hash chain */
	dev_t n_dev;			/* device and inode number of the */
	ino_t n_ino;			/* inode containing the name */
	dev_t n_tdev;			/* device and inode number of the */
	ino_t n_tino;			/* inode refered to by name */
	struct inode *n_ip;		/* cached inode pointer */
	unsigned n_usage;		/* usage of this entry */
	int n_hash;			/* hash value of this entry */
} name_cache[NR_NAMES];

EXTERN char name_strings[NR_NAMES * NAME_SIZE];
EXTERN struct name *name_hash[NR_NAMES_HASH];

_PROTOTYPE( void flush_names, (Dev_t dev, Ino_t ino)			);
_PROTOTYPE( void flush_name, (Dev_t dev, Ino_t ino, char *name)		);
_PROTOTYPE( int hash_name, (Dev_t dev, Ino_t ino, char *name)		);
_PROTOTYPE( void enter_name, (int hash, Dev_t dev, Ino_t ino, char *name,
			Dev_t tdev, Ino_t tino, struct inode *ip)	);
_PROTOTYPE( struct name *lookup_name, (int hash, Dev_t dev, Ino_t ino,
							char *name)	);

/*
 * $PchId: name.h,v 1.2 1995/11/28 08:31:51 philip Exp $
 */
