/* EXTERN should be extern except for the table file */
#ifdef _TABLE
#undef EXTERN
#define EXTERN
#endif

/* File System global variables */
EXTERN dev_t root_dev;		/* device number of the root device */
EXTERN struct fproc *fp;	/* pointer to caller's fproc struct */
EXTERN int super_user;		/* 1 if caller is super_user, else 0 */
EXTERN int dont_reply;		/* normally 0; set to 1 to inhibit reply */
EXTERN int curr_fd;		/* Temporary global var for the current fd */
EXTERN int call_lock_revive;
EXTERN struct file_lock *free_locks;

/* The parameters of the call are kept here. */
EXTERN message m;		/* the input message itself */
EXTERN message m1;		/* the output message used for reply */
EXTERN int who;			/* caller's proc number */
EXTERN int fs_call;		/* system call number */
EXTERN char user_path[PATH_MAX];/* storage for user path name */

/* The following variables are used for returning results to the caller. */
EXTERN int rdwt_err;		/* status of last disk i/o request */


/* Data which needs static initialization. */
extern _PROTOTYPE (int (*scall_table[]), (void) );
				/* table of system calls handled by FS */
extern struct utsname uts_val;	/* machine name, O.S. name, etc. */
extern char *uts_tbl[];
extern struct super_block *pipe_fs;	/* filesystem to allocate pipes on */

extern char dot1[2];   /* dot1 (&dot1[0]) and dot2 (&dot2[0]) have a special */
extern char dot2[3];   /* meaning to search_dir: no access permission check. */

extern int asio_ip[ASIO_NR];	/* convert ASIO_xx to ODF_xx_IP */
extern int asio_compl[ASIO_NR];	/* convert ASIO_xx to ODF_xx_COMPL */
extern int asio_cancel[ASIO_NR]; /* convert ASIO_xx to CANCEL_xx */
extern int asio_event[ASIO_NR]; /* convert ASIO_xx to EV_DEVxx */

extern int clck_tasknr;

/*
 * $PchId: glo.h,v 1.5 1995/11/28 08:13:20 philip Exp $
 */
