/* This is the per-process information.  A slot is reserved for each potential
 * process. Thus NR_PROCS must be the same as in the kernel. It is not possible
 * or even necessary to tell when a slot is free here.
 */


EXTERN struct fproc {
  mode_t fp_umask;		/* mask set by umask system call */
  struct inode *fp_workdir;	/* pointer to working directory's inode */
  struct inode *fp_rootdir;	/* pointer to current root dir (see chroot) */
  struct od *fp_filp[OPEN_MAX]; /* the file descriptor table */
  uid_t fp_realuid;		/* real user id */
  uid_t fp_effuid;		/* effective user id */
  gid_t fp_realgid;		/* real group id */
  gid_t fp_effgid;		/* effective group id */
  gid_t fp_groups[NGROUPS_MAX];	/* supplementary group id's */
  int fp_ngroups;		/* number of group id's */
  dev_t fp_tty;			/* major/minor of controlling tty */
  struct filp *fp_ttyfilp;	/* filp for real contrlling tty. */
  int fp_ttylink;		/* number open /dev/ttys */
  int  fp_event;		/* which event is proc suspended on */
  union
  {
  	struct
  	{
  		int fp_fd;
  	} fp_rwio;
  	struct
  	{
  		int fp_fd;
  	} fp_popen;
  	struct
  	{
  		char *fp_buffer;
		struct asio_fd_set fp_fds;	/* Which file descriptors can wake us up. */
  	} fp_fwait;
  	struct
  	{
  		struct filp *fp_filp;
  		int fp_type;
  		unsigned long fp_start;
  		unsigned long fp_end;
  		struct fproc *fp_blkproc;
  	} fp_lock;
  } fp_state;
  pid_t fp_pid;			/* process id */
  int fp_sesldr;		/* process is a session leader. */
  long fp_cloexec;		/* bit map for POSIX Table 6-2 FD_CLOEXEC */
} fproc[NR_PROCS];

#define PID_FREE	  0	/* process slot free */
#define PID_SERVER	(-1)	/* process has become a server */

/*
 * $PchId: fproc.h,v 1.5 1995/11/28 08:33:26 philip Exp $
 */
