/* Tables sizes */
#define V1_NR_DZONES       7	/* # direct zone numbers in a V1 inode */
#define V1_NR_TZONES       9	/* total # zone numbers in a V1 inode */
#define V2_NR_DZONES       7	/* # direct zone numbers in a V2 inode */
#define V2_NR_TZONES      10	/* total # zone numbers in a V2 inode */

#define NR_ODS		 512	/* # slots in od table */
#define NR_FILPS         256	/* # slots in filp table */
#define NR_INODES        128	/* # slots in "in core" inode table */
#define NR_INODE_HASH	 256	/* # slots in inode hash table */
#define NR_SUPERS         16	/* # slots in super block table */
#define NR_MOUNTS         20	/* # slots in the table of mounts */
#define NR_LOCKS          32	/* # slots in the file locking table */
#define NR_DMAPS	  32	/* # slots in the device map */

/* The type of sizeof may be (unsigned) long.  Use the following macro for
 * taking the sizes of small objects so that there are no surprises like
 * (small) long constants being passed to routines expecting an int.
 */
#define usizeof(t) ((unsigned) sizeof(t))

/* File system types. */
#define SUPER_MAGIC   0x137F	/* magic number contained in super-block */
#define SUPER_REV     0x7F13	/* magic # when 68000 disk read on PC or vv */
#define SUPER_V2      0x2468	/* magic # for V2 file systems */
#define SUPER_V2_REV  0x6824	/* V2 magic written on PC, read on 68K or vv */

#define V1		   1	/* version number of V1 file systems */ 
#define V2		   2	/* version number of V2 file systems */ 

/* Fsck marks a superblock with this magic number for use of the clean flag. */
#define FSCK_MAGIC0   0x7F
#define FSCK_MAGIC1   0x13

/* Miscellaneous constants */
#define SU_UID 	 ((uid_t) 0)	/* super_user's uid_t */
#define SYS_UID  ((uid_t) 0)	/* uid_t for processes MM and INIT */
#define SYS_GID  ((gid_t) 0)	/* gid_t for processes MM and INIT */
#define BF_NORMAL          0	/* forces get_block to do disk read */
#define BF_ALLOC           1	/* prevents get_block from doing disk read */
#define BF_LOOK            2	/* tells get_block to return a block only if
				 * it is already in the cache
				 */
#define BF_USAGE_SHIFT	   2	/* shift this many bits in the 2nd chance
				 * buffer allocation algorithm
				 */
#if VMDEXT_FS_FAST_CREATE
#define EXTENT_SIZE	((uoff_t)0x20000L) /* Allocate zones more efficiently
				 * after 128K */
#endif /* VMDEXT_FS_FAST_CREATE */

#define MP_INODE	   1	/* Search the inode bitmap */
#define MP_ZONE		   2	/* Search the zone bitmap */

#define EV_NONE		   0	/* not suspended */
#define EV_LOCK		   1	/* suspended on lock */
#define EV_POPEN	   2	/* suspended on pipe open */
#define EV_FWAIT	   3	/* suspended on fwait */
#define EV_READ		   4	/* suspended on a pipe or device read */
#define EV_WRITE	   5	/* suspended on a pipe or device write */
#define EV_IOCTL	   6	/* suspended on a device ioctl */

#define NO_BIT   ((bit_t) 0)	/* returned by alloc_bit() to signal failure */
#define DUP_MASK        0100	/* mask to distinguish dup2 from dup */

#define LOOK_UP            0	/* tells search_dir to lookup string */
#define ENTER              1	/* tells search_dir to make dir entry */
#define DELETE             2	/* tells search_dir to delete entry */
#define IS_EMPTY           3	/* tells search_dir to ret. OK or ENOTEMPTY */  

#if VMDEXT_SYMLINK
#define PATH_TRANSPARENT 000	/* parse_path stops at final object */
#define PATH_PENULTIMATE 001	/* parse_path stops at last but one name */
#define PATH_OPAQUE      002	/* parse_path stops at final name */
#define PATH_NONSYMBOLIC 004	/* parse_path scans final name if symbolic */
#define PATH_STRIPDOT    010	/* parse_path strips /. from path */
#define EAT_PATH         PATH_TRANSPARENT
#define EAT_PATH_OPAQUE  PATH_OPAQUE
#define LAST_DIR         PATH_PENULTIMATE
#define LAST_DIR_NOTDOT  PATH_PENULTIMATE | PATH_STRIPDOT
#define LAST_DIR_EATSYM  PATH_NONSYMBOLIC
#endif /* VMDEXT_SYMLINK */

#define CLEAN              0	/* disk and memory copies identical */
#define DIRTY              3	/* disk and memory copies differ */
#define GRIMY              1	/* some dirty blocks don't get synced alone */
#define ATIME            002	/* set if atime field needs updating */
#define CTIME            004	/* set if ctime field needs updating */
#define MTIME            010	/* set if mtime field needs updating */

#define BYTE_SWAP          0	/* tells conv2/conv4 to swap bytes */
#define DONT_SWAP          1	/* tells conv2/conv4 not to swap bytes */

#define END_OF_FILE   (-104)	/* eof detected */

#define ROOT_INODE         1	/* inode number for root directory */
#define BOOT_BLOCK  ((block_t) 0)	/* block number of boot block */
#define SUPER_BLOCK ((block_t) 1)	/* block number of super block */

#define DIR_ENTRY_SIZE usizeof (struct _v7_direct)  /* # bytes/dir entry   */
#define FL_DIR_ENTRY_SIZE usizeof (struct _fl_direct)  /* # flex # bts/de     */
#define NR_DIR_ENTRIES   (BLOCK_SIZE/DIR_ENTRY_SIZE)  /* # dir entries/blk   */
#define FL_NR_DIR_ENTRIES (BLOCK_SIZE/FL_DIR_ENTRY_SIZE) /* flex # de/blk    */
#define SUPER_SIZE      usizeof (struct super_block)  /* super_block size    */
#define PIPE_SIZE          (V1_NR_DZONES*BLOCK_SIZE)  /* pipe size in bytes  */
#define BITMAP_CHUNKS (BLOCK_SIZE/usizeof (bitchunk_t))/* # map chunks/blk   */

/* Derived sizes pertaining to the V1 file system. */
#define V1_ZONE_NUM_SIZE           usizeof (zone1_t)  /* # bytes in V1 zone  */
#define V1_INODE_SIZE             usizeof (d1_inode)  /* bytes in V1 dsk ino */
#define V1_INDIRECTS   (BLOCK_SIZE/V1_ZONE_NUM_SIZE)  /* # zones/indir block */
#define V1_INODES_PER_BLOCK (BLOCK_SIZE/V1_INODE_SIZE)/* # V1 dsk inodes/blk */
#define V1_LINK_MAX                CHAR_MAX           /* max # links */

/* Derived sizes pertaining to the V2 file system. */
#define V2_ZONE_NUM_SIZE            usizeof (zone_t)  /* # bytes in V2 zone  */
#define V2_INODE_SIZE             usizeof (d2_inode)  /* bytes in V2 dsk ino */
#define V2_INDIRECTS   (BLOCK_SIZE/V2_ZONE_NUM_SIZE)  /* # zones/indir block */
#define V2_INODES_PER_BLOCK (BLOCK_SIZE/V2_INODE_SIZE)/* # V2 dsk inodes/blk */
#define V2_LINK_MAX                SHRT_MAX           /* max # links */

#define CTTY_MAJOR	5	/* Major device number of /dev/tty */

#define printf printk

#define conv2(native, v)	\
	((native) ? (unsigned)((v) & 0xffff) : swap2((v)))
#define conv4(native, v)	\
	((native) ? (long)((v) & 0xffffffff) : swap4((v)))

#if PCH_DEBUG
#define where() printf("%s, %d:\n\t", __FILE__, __LINE__)
#else /* !PCH_DEBUG */
#define where() ((void)0)
#endif /* !PCH_DEBUG */

/*
 * $PchId: const.h,v 1.6 1995/11/28 08:24:10 philip Exp $
 */
