/* _utime(2) for POSIX		Authors: Terrence W. Holm & Edwin L. Froese */

#include <minix/stubs.h>
#include <string.h>
#include <time.h>
#include <utime.h>
#include <minix/type.h>
#include <minix/callnr.h>
#include <minix/minlib.h>

int utime(name, timp)
_CONST char *name;
_CONST struct utimbuf *timp;
{
	message m;

	if (timp == (struct utimbuf *)NULL) {
		m.m2_l1 = 0;
		m.m2_l2 = 0;
		m.m2_i2 = 1;	/* signals "set to current time" */
	} else {
		m.m2_l1 = timp->actime;
		m.m2_l2 = timp->modtime;
		m.m2_i2 = 0;
	}

	m.m2_i1 = strlen(name)+1;
	m.m2_p1 = (char *)name;

	/* Clear unused fields */
	m.m2_i3 = 0;

	return _syscall(PROC_FS, UTIME, &m);
}

/*
 * $PchId: _utime.c,v 1.4 1995/11/27 19:40:23 philip Exp $
 */
