#include <minix/stubs.h>
#include <time.h>
#include <sys/times.h>
#include <sys/types.h>
#include <minix/type.h>
#include <minix/callnr.h>
#include <minix/minlib.h>

clock_t times(buf)
struct tms *buf;
{
	message m;
	int r;

	/* Clear unused fields */
	m.m1_i1 = 0;
	m.m1_i2 = 0;
	m.m1_i3 = 0;
	m.m1_p1 = NULL;
	m.m1_p2 = NULL;
	m.m1_p3 = NULL;

	r = _syscall(PROC_FS, TIMES, &m);
	if (r == -1)
		return -1;

	buf->tms_utime = m.m4_l1;
	buf->tms_stime = m.m4_l2;
	buf->tms_cutime = m.m4_l3;
	buf->tms_cstime = m.m4_l4;
	return m.m4_l5;
}

/*
 * $PchId: _times.c,v 1.4 1995/11/27 19:41:03 philip Exp $
 */
