/*
syscall/_time.c

Created:	June 7, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#include <minix/stubs.h>
#include <time.h>
#include <minix/type.h>
#include <minix/callnr.h>
#include <minix/minlib.h>

long time(tp)
long *tp;
{
	message m;
	int r;
	long t;

	/* Clear unused fields */
	m.m1_i1 = 0;
	m.m1_i2 = 0;
	m.m1_i3 = 0;
	m.m1_p1 = NULL;
	m.m1_p2 = NULL;
	m.m1_p3 = NULL;

	r = _syscall(PROC_FS, TIME, &m);
	if (r == -1)
		return -1;

	t = m.m2_l1;
	if (tp != NULL) *tp = t;
	return t;
}

/*
 * $PchId: _time.c,v 1.5 1995/11/27 19:41:11 philip Exp $
 */
