/*	svrctl() - special server control functions.	Author: Kees J. Bot
 *								24 Apr 1994
 */
#include <minix/stubs.h>
#include <minix/type.h>
#include <minix/callnr.h>
#include <minix/minlib.h>
#include <sys/types.h>
#include <sys/svrctl.h>
#include <errno.h>
#include <stdarg.h>

int svrctl(ioreq_t request, void *argp)
{
	message m;

	m.m2_l1 = request;
	m.m2_p1 = argp;

	/* Clear unused fields */
	m.m2_i1 = 0;
	m.m2_i2 = 0;
	m.m2_i3 = 0;
	m.m2_l2 = 0;

	switch ((request >> 8) & 0xFF) {
	case 'M':
	case 'S':
		/* MM handles calls for itself and the kernel. */
		return _syscall(PROC_MM, SVRCTL, &m);
	case 'F':
	case 'I':
		/* FS handles calls for itself and inet. */
		return _syscall(PROC_FS, SVRCTL, &m);
	default:
		errno = EINVAL;
		return -1;
	}
}

/*
 * $PchId: _svrctl.c,v 1.3 1995/11/27 19:43:05 philip Exp $
 */
