/*
syscall/_sigsuspend.c

Created:	Oct 5, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#include <minix/stubs.h>
#include <signal.h>
#include <stdlib.h>
#include <sys/types.h>
#include <minix/type.h>
#include <minix/callnr.h>
#include <minix/minlib.h>

int sigsuspend(const sigset_t *set)
{
	message m;

	m.m2_l1 = *set;

	/* Clear unused fields */
	m.m2_i1 = 0;
	m.m2_i2 = 0;
	m.m2_i3 = 0;
	m.m2_l2 = 0;
	m.m2_p1 = NULL;

	return _syscall(PROC_MM, SIGSUSPEND, &m);
}

/*
 * $PchId: _sigsuspend.c,v 1.4 1995/11/27 19:43:36 philip Exp $
 */
