/*
syscall/_sigreturn.c

Modified:	July 9, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#define _POSIX_SOURCE

#include <minix/stubs.h>
#include <setjmp.h>
#include <signal.h>
#include <stdlib.h>
#include <sys/sigcontext.h>
#include <minix/type.h>
#include <minix/callnr.h>
#include <minix/minlib.h>

#if 0
#if (_SETJMP_SAVES_REGS == 0)
/* 'sigreturn' using a short format jmp_buf (no registers saved). */
PUBLIC int sigjmp(jb, retval)
jmp_buf jb;
int retval;
{
  struct sigcontext sc;

  sc.sc_flags = jb[0].__flags;
  sc.sc_mask = jb[0].__mask;

#if (CHIP == INTEL)
  sc.sc_pc = (int) jb[0].__pc;
  sc.sc_sp = (int) jb[0].__sp;
  sc.sc_fp = (int) jb[0].__lb;
#endif

#if (CHIP == M68000)
  sc.sc_pc = (long) jb[0].__pc;
  sc.sc_sp = (long) jb[0].__sp;
  sc.sc_fp = (long) jb[0].__lb;
#endif

  sc.sc_retreg = retval;
  return sigreturn(&sc);
}
#endif
#endif

int sigreturn(scp)
register struct sigcontext *scp;
{
	sigset_t set;
	int r;

	/* The message can't be on the stack, because the stack will vanish out
	* from under us.  The send part of sendrec will succeed, but when
	* a message is sent to restart the current process, who knows what will
	* be in the place formerly occupied by the message? Note that the
	* stack will go up because of the sigreturn, but the new signal mask
	* may cause new signal handlers to be pushed, before the reply!
	*/
	static message m;

	/* Protect against race conditions by blocking all interrupts. */
	r= sigfillset(&set);		/* splhi */
	if (r == -1) return -1;
	r= sigprocmask(SIG_SETMASK, &set, (sigset_t *) NULL);
	if (r == -1) return -1;

	m.m2_i2 = scp->sc_flags;
	m.m2_l1 = scp->sc_mask;
	m.m2_p1 = (char *) scp;

	/* Clear unused fields */
	m.m2_i1 = 0;
	m.m2_i3 = 0;
	m.m2_l2 = 0;

	/* Normally this doesn't return. */
	return _syscall(PROC_MM, SIGRETURN, &m);
}

/*
 * $PchId: _sigreturn.c,v 1.4 1995/11/27 19:43:45 philip Exp $
 */
