/*
syscall/_sigprocmask.c

Created:	Oct 4, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#define _POSIX_SOURCE

#include <minix/stubs.h>
#include <signal.h>
#include <stdlib.h>
#include <sys/types.h>
#include <minix/type.h>
#include <minix/callnr.h>
#include <minix/minlib.h>

int sigprocmask(int how, const sigset_t *set, sigset_t *oset)
{
	int ret;
	message m;

	if (set == NULL) {
		m.m2_i1 = SIG_INQUIRE;
		m.m2_l1 = 0L;
	} else {
		m.m2_i1 = how;
		m.m2_l1 = (long) *set;
	}

	/* Clear unused fields */
	m.m2_i2 = 0;
	m.m2_i3 = 0;
	m.m2_l2 = 0;
	m.m2_p1 = NULL;

	ret = _syscall(PROC_MM, SIGPROCMASK, &m);
	if (ret == -1)
		return -1;
	if (oset != NULL) *oset = (sigset_t)(m.m2_l1);

	return ret;
}

/*
 * $PchId: _sigprocmask.c,v 1.4 1995/11/27 19:43:56 philip Exp $
 */
