/*
syscall/_sigaction.c

Created:	July 9, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#include <minix/stubs.h>
#include <sys/sigcontext.h>
#include <signal.h>
#include <minix/type.h>
#include <minix/callnr.h>
#include <minix/minlib.h>

int __sigreturn(struct sigcontext *);	/* Special wrapper for sigreturn. */

int sigaction(sig, act, oact)
int sig;
_CONST struct sigaction *act;
struct sigaction *oact;
{
	message m;

	m.m1_i2 = sig;
	m.m1_p1 = (char *) act;
	m.m1_p2 = (char *) oact;
	m.m1_p3 = (char *) __sigreturn;

	/* Clear unused fields */
	m.m1_i1 = 0;
	m.m1_i3 = 0;

	return _syscall(PROC_MM, SIGACTION, &m);
}

/*
 * $PchId: _sigaction.c,v 1.4 1995/11/27 19:44:21 philip Exp $
 */
