/*	_setgroups() - set supplementary groups		Author: Kees J. Bot
 *								17 Jan 1994
 */

#include <minix/stubs.h>
#include <sys/types.h>
#include <unistd.h>
#include <minix/type.h>
#include <minix/callnr.h>
#include <minix/minlib.h>
#include <errno.h>

int setgroups(int gidsetlen, gid_t *gidset)
{
	message m;
	int i;

	for (i = gidsetlen == 0 ? -1 : 0; i < gidsetlen; i++) {
		m.m1_i1 = 1;
		m.m1_i2 = i;
		m.m1_i3 = gidsetlen == 0 ? 0 : gidset[i];

		/* Clear unused fields */
		m.m1_p1 = NULL;
		m.m1_p2 = NULL;
		m.m1_p3 = NULL;

		if (_syscall(PROC_MM, GSGROUPS, &m) == -1) return -1;
	}
	return 0;
}

/*
 * $PchId: _setgroups.c,v 1.4 1995/11/27 19:44:57 philip Exp $
 */
