/* reboot.c - Systemcall interface to mm/misc.c::do_reboot()

   author: Edvard Tuinder  v892231@si.hhs.NL
 */

#define _MINIX_SOURCE

#include <minix/stubs.h>
#include <errno.h>
#include <unistd.h>
#include <stdarg.h>
#include <minix/type.h>
#include <minix/callnr.h>
#include <minix/minlib.h>

int reboot(int how, ...)
{
	message m;
	va_list ap;

	va_start(ap, how);

	if ((m.m1_i1 = how) == RBT_MONITOR) {
		m.m1_p1 = va_arg(ap, char *);
		m.m1_i2 = va_arg(ap, size_t);
	} else {
		m.m1_p1 = NULL;
		m.m1_i2 = 0;
	}
	va_end(ap);

	/* Clear unused fields */
	m.m1_i3 = 0;
	m.m1_p2 = NULL;
	m.m1_p3 = NULL;

	return _syscall(PROC_MM, REBOOT, &m);
}

/*
 * $PchId: _reboot.c,v 1.4 1995/11/27 19:46:06 philip Exp $
 */
