/*
syscall/_lstat.c

Created:	June 12, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#define _MINIX_SOURCE

#include <minix/stubs.h>
#include <errno.h>
#include <string.h>
#include <sys/stat.h>
#include <minix/type.h>
#include <minix/callnr.h>
#include <minix/minlib.h>

int lstat(name, buffer)
_CONST char *name;
struct stat *buffer;
{
	int r;
	message m;

	m.m1_i1 = strlen(name)+1;
	m.m1_p1 = (char *)name;
	m.m1_p2 = (char *)buffer;

	/* Clear unused fields */
	m.m1_i2 = 0;
	m.m1_i3 = 0;
	m.m1_p3 = NULL;

	r = _syscall(PROC_FS, LSTAT, &m);
	if (r != -1 || errno != ENOSYS)
		return r;

  	/* Try stat, just in case symlinks are not supported */
	m.m1_i1 = strlen(name)+1;
	m.m1_p1 = (char *)name;
	m.m1_p2 = (char *)buffer;

	/* Clear unused fields */
	m.m1_i2 = 0;
	m.m1_i3 = 0;
	m.m1_p3 = NULL;

	return _syscall(PROC_FS, STAT, &m);
}

/*
 * $PchId: _lstat.c,v 1.4 1995/11/27 19:52:33 philip Exp $
 */
