/*
syscall/_fcntl.c

Created:	June 7, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#define _MINIX_SOURCE

#include <minix/stubs.h>
#include <fcntl.h>
#include <stdarg.h>
#include <stdlib.h>
#include <minix/type.h>
#include <minix/callnr.h>
#include <minix/minlib.h>
#include <minix/partition.h>

#if _ANSI
int fcntl(int fd, int cmd, ...)
#else
int fcntl(fd, cmd)
int fd;
int cmd;
#endif
{
	message m;
	va_list argp;
	u64_t pos;

	va_start(argp, cmd);

	/* Set up for the sensible case where there is no variable parameter.
	 * This covers F_GETFD, F_GETFL and invalid commands.
	 */
	m.m1_i3 = 0;
	m.m1_p1 = NULL;

	/* Adjust for the stupid cases. */
	switch(cmd) {
	case F_DUPFD:
	case F_SETFD:
	case F_SETFL:
		m.m1_i3 = va_arg(argp, int);
		break;
	case F_GETLK:
	case F_SETLK:
	case F_SETLKW:
	case F_FREESP:
		m.m1_p1 = (char *) va_arg(argp, struct flock *);
		break;
	case F_SEEK:
		pos = va_arg(argp, u64_t);
		m.m1_p1 = (char *) &pos;
		break;
	}

	/* Clean up and make the system call. */  
	va_end(argp);	

	m.m1_i1 = fd;
	m.m1_i2 = cmd;
	/* m.m1_i3 is already filled in */
	/* m.m1_p1 is already filled in */

	/* Clear unused fields */
	m.m1_p2 = NULL;
	m.m1_p3 = NULL;

	return _syscall(PROC_FS, FCNTL, &m);
}

/*
 * $PchId: _fcntl.c,v 1.4 1995/11/27 19:57:19 philip Exp $
 */
