/*	ttyname() - name the terminal device a file descriptor refers to
 *
 *							Author: Kees J. Bot
 *								25 Jan 1994
 */

#define _POSIX_SOURCE

#define nil 0
#include <minix/stubs.h>
#include <limits.h>
#include <dirent.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>

char *ttyname(int fd)
{
	static char name[4 + 1 + NAME_MAX + 1];	/* /dev/ttyXX */
	DIR *dp;
	struct dirent *entry;
	struct stat look, device;
	int pass;

	/* What device are we looking for? */
	if (fstat(fd, &look) < 0 || !S_ISCHR(look.st_mode)) return nil;

	if ((dp= opendir("/dev")) == nil) return nil;

	for (pass= 0; pass < 2; pass++) {
		/* Quick scan of the directory on the first pass.  Stat every
		 * entry on the second pass to follow symlinks.
		 */
		while ((entry= readdir(dp)) != nil) {
			if (pass == 0 && entry->d_ino != look.st_ino) continue;

			strcpy(name, "/dev/");
			strcpy(name + 5, entry->d_name);

			if (stat(name, &device) < 0) continue;

			if (look.st_ino == device.st_ino
					&& look.st_dev == device.st_dev) {
				goto found;
			}
		}
		rewinddir(dp);
	}
found:
	(void) closedir(dp);
	return entry == nil ? nil : name;
}

/*
 * $PchId: ttyname.c,v 1.5 1995/11/27 20:07:52 philip Exp $
 */
