/*	sysconf() - query system limits			Author: Kees J. Bot
 *								25 Jan 1994
 *
 * Sysconf returns the current system limits, like the maximum number of
 * arguments that can be passed to a child process.  These values need not
 * be the same on the next invocation of the program, although under Minix
 * they are.
 */

#define _POSIX_SOURCE

#include <limits.h>
#include <unistd.h>
#include <time.h>
#include <errno.h>

#ifndef ARG_MAX
/* ARG_MAX is undefined because it depends only on the amount of
 * (virtual) memory available for the process calling one of the exec
 * routines and on the amount of physical memory available.
 * We define ARG_MAX to a "large" value because POSIX requires some
 * answer.
 */
#define ARG_MAX		0x100000
#endif

long sysconf(int name)
{
	static struct sysconf {
		int	name;
		long	value;
	} conf[]= {
		{ _SC_ARG_MAX,		ARG_MAX		},
		{ _SC_CHILD_MAX,	CHILD_MAX	},
		{ _SC_CLOCKS_PER_SEC,	CLOCKS_PER_SEC	},
		{ _SC_NGROUPS_MAX,	NGROUPS_MAX	},
		{ _SC_OPEN_MAX,		OPEN_MAX	},
		{ _SC_JOB_CONTROL,	0		},
		{ _SC_SAVED_IDS,	1		},
		{ _SC_VERSION,		_POSIX_VERSION	},
		{ _SC_STREAM_MAX,	STREAM_MAX	},
		{ _SC_TZNAME_MAX,	TZNAME_MAX	},
	};
	struct sysconf *pc;

	for (pc= conf; pc < conf + sizeof(conf)/sizeof(conf[0]); pc++) {
		if (pc->name == name) return pc->value;
	}

	errno= EINVAL;
	return -1;
}

/*
 * $PchId: sysconf.c,v 1.4 1995/11/27 20:07:59 philip Exp $
 */
