/*	getlogin() - name the user			Author: Kees J. Bot
 *								25 Jan 1994
 *
 * Modified by Philip Homburg to use ttyslot() and the utmp file.
 */

#define _MINIX_SOURCE

#define nil 0
#include <minix/stubs.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <utmp.h>

char *getlogin(void)
{
	static char user[_U_USERSIZE+1];
	struct utmp ent;
	int slot;
	int fd;

	slot= ttyslot();
	if (slot == 0)
		return nil;
	fd= open(_U_UTMP, O_RDONLY);
	if (fd == -1)
		return nil;
	if (lseek(fd, slot*sizeof(struct utmp), SEEK_SET) == -1L)
	{
		close(fd);
		return nil;
	}
	if (read(fd, &ent, sizeof(ent)) != sizeof(ent))
	{
		close(fd);
		return nil;
	}
	close(fd);
	if (ent.ut_type != USER_PROCESS)
		return nil;
	strncpy(user, ent.ut_user, _U_USERSIZE);
	user[_U_USERSIZE]= '\0';
	return user;
}

/*
 * $PchId: getlogin.c,v 1.5 1995/11/27 20:08:06 philip Exp $
 */
