/*
libc/os/minix/posix/_sleep.c

Created:	Oct 4, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#define _MINIX_SOURCE
#define _POSIX_SOURCE

#include <minix/stubs.h>
#include <errno.h>
#include <signal.h>
#include <time.h>
#include <unistd.h>

static void alarm_dummy _ARGS(( int sig ));

unsigned int sleep(seconds)
unsigned int seconds;
{
	sigset_t ss, ss_orig, ss_tmp;
	struct timeval curr_time, time_out, timer_orig;
	struct sigaction action, action_orig;
	int r;
	int restore_procmask;
	int restore_handler;
	int restore_timer;

	r= 0;
	restore_procmask= 0;
	restore_handler= 0;
	restore_timer= 0;

	/* Block all signals */
	if (r != -1) r= sigfillset(&ss);
	if (r != -1) r= sigemptyset(&ss_orig);
	if (r != -1) r= sigprocmask(SIG_BLOCK, &ss, &ss_orig);
	if (r != -1) restore_procmask= 1;

	/* Calculate timeout */
	if (r != -1) r= sysutime(UTIME_TIMEOFDAY, &curr_time);
	if (r != -1)
	{
		time_out.tv_sec= curr_time.tv_sec + seconds;
		time_out.tv_usec= curr_time.tv_usec;
	}

	/* Cancel old timer, and get value of that timer */
	if (r != -1)
	{
		timer_orig.tv_sec= 0;
		timer_orig.tv_usec= 0;
		r= sysutime(UTIME_SETALARM, &timer_orig);
		if (r != -1)
			restore_timer= 1;
	}

	/* Register new signal handler */
	if (r != -1)
	{
		action.sa_handler= alarm_dummy;
		sigemptyset(&action.sa_mask);
		action.sa_flags= 0;
		r= sigaction(SIGALRM, &action, &action_orig);
		if (r != -1)
			restore_handler =1;
	}

	/* Set new timer */
	if (r != -1)
	{
		if (timer_orig.tv_sec != 0 && timer_orig.tv_sec <
			time_out.tv_sec)
		{
			time_out=timer_orig;
		}
		r= sysutime(UTIME_SETALARM, &time_out);
	}

	/* Wait until something happens */
	if (r != -1)
	{
		ss_tmp= ss_orig;
		sigdelset(&ss_tmp, SIGALRM);
		r= sigsuspend(&ss_tmp);
		if (r == -1 && errno == EINTR)
			r= 0;
	}

	if (restore_timer)
		sysutime(UTIME_SETALARM, &timer_orig);
	if (restore_handler)
		sigaction(SIGALRM, &action_orig, NULL);
	if (restore_procmask)
		sigprocmask(SIG_SETMASK, &ss_orig, NULL);

	/* Calculate the remaining time */
	time_out= curr_time;
	sysutime(UTIME_TIMEOFDAY, &time_out);
	time_out.tv_sec -= curr_time.tv_sec;
	time_out.tv_usec -= curr_time.tv_usec;
	if (time_out.tv_usec < 0)
		time_out.tv_sec--;
	if (time_out.tv_sec < 0)
		time_out.tv_sec= 0;
	if (time_out.tv_sec < seconds)
		return seconds-time_out.tv_sec;
	else	
		return 0;
}

static void alarm_dummy(sig)
int sig;
{
}

/*
 * $PchId: _sleep.c,v 1.4 1995/11/27 20:11:02 philip Exp $
 */
